{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
   <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />



{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }   

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    } 

</style>
<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>List of products by invoices</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>
                <input type="text" class=" tener_role_id" value={$roleid} disabled hidden   />

 
            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">
 
                               
                            {* listado de staff *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="state_form"><span style="color:#666;">Staff</span> </label>
                                <select
                                    class="form-select form-control-sm tener_staff"
                                    name="staff"
                                    id="staff"
                                    style="width: 100%"
                                    placeholder="Select a Staff"
                                   
                                >
                                    <option value="" >All</option>
                                    {foreach $listado_staff as $ds}
                                        <option value="{$ds['id']}" >{$ds['fullname']}</option>
                                    {/foreach}
                                </select>
                            </div>

                           {* listado de cliente *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="customers"><span style="color:#666;">Customer</span> </label>
                                <select
                                    class="form-select form-control-sm tener_customers"
                                    name="customers"
                                    id="customers"
                                    style="width: 100%"
                                    placeholder="Select a customer"
                                >
                                    <option value="">All</option>

                                    {foreach $listado_clientes as $ds}
                                       <option value="{$ds['id']}" data-email="{$ds['email']}" data-account="{$ds['account']}" >{$ds['account']}</option>
                                    {/foreach}
                                </select>
                            </div>

                               

                            {* listado de productos *}
                            <div class="col-12 col-sm-12 pt-3">
                                <label for="productos"><span style="color:#666;">Productos</span> </label>
                                <select
                                    class="form-select form-control-sm tener_productos"
                                    name="productos"
                                    id="productos"
                                    style="width: 100%"
                                    placeholder="Select a product"
                                >
                                    <option value="">All</option>

                                    {foreach $listado_productos as $ds}
                                       <option value="{$ds['id']}" >{$ds['name']}</option>
                                    {/foreach}
                                </select>
                            </div>


                            {* fecha desde *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_desde"
                                    ><span style="color:#666;">Date from</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_desde"
                                    name="fecha_desde"
                                    class="form-control form-control-sm tener_fecha_desde"
                                />
                            </div>

                           {* fecha hasta *}
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_hasta"
                                    ><span style="color:#666;">Date to date</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_hasta"
                                    name="fecha_hasta"
                                    class="form-control form-control-sm tener_fecha_hasta"
                                />
                            </div>
 
 
                            <div class="col-12 col-sm-12 pt-3">
                              
                                <button
                                    type="button"
                                    class="btn btn-default"
                                    id="consultar_filtros"
                                    style="
                                        border-color: #d3cac0;
                                        border: 1px solid #d3cac0;
                                        float: right;
                                    "
                                >
                                    Search
                                </button>
                              
                              <button
                                    type="button"
                                    class="btn btn-success"
                                    id="consultar_filtros_excel"
                                    style="
                                        float: right;
                                        margin-right: 7px;
                                    "
                                >
                                    Download Excel
                                </button>

                            </div>

   
                           
                            <br />
                             
                            <div class="col-12 col-sm-12 pt-4">
                            
                            
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                                        <thead>
                                        <tr>
                                            <th class="centrar">Date</th>
                                            <th class="centrar">Staff</th>
                                            <th class="centrar">Customers</th>
                                            <th class="centrar">phone</th>
                                            <th class="centrar">email</th>
                                            <th class="centrar">address</th>
                                            {*
                                            <th class="centrar">City</th>
                                            <th class="centrar">State</th>
                                            
                                            *}
                                            <th class="centrar">Refered by</th>
                                            <th class="centrar">No. Invoices</th>
                                            <th class="centrar">Product name</th>
                                            <th class="centrar">Product quantity</th>
                                            <th class="centrar">Product value</th>
                                            <th class="centrar">Total product</th>
                                           
                                        </tr>
                                        </thead>
                                        <tbody class="tbody_envios">
                                        
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>

<script>

 

   const URL_BASE      = $(".tener_url_base").val();
   const tener_role_id = $(".tener_role_id").val();

   let tener_parametro_estado_id = $(".tener_parametro_estado_id").val();
   let tener_parametro_staff_id  = $(".tener_parametro_staff_id").val();

   let tener_url_formulario_w7  = $(".tener_url_formulario_w7").val();
   let tener_url_formulario_656  = $(".tener_url_formulario_656").val();
   let tener_url_formulario_433  = $(".tener_url_formulario_433").val();

 
    //cargar_usuarios_sistema().then((listado_usuarios_admin) =>{
    //    $(".tener_usuario_id").html(
    //        select_html_usuario_sistema(listado_usuarios_admin),
    //    );
    //});

   $country = $(".tener_customers");
   $country.select2();

   $(".tener_productos").select2();
    

   let fecha = cargar_fecha();
   $(".tener_fecha_desde").val(fecha);
   $(".tener_fecha_hasta").val(fecha);

 
 

    //$('#clx_datatable').DataTable();
 
 
         $("#consultar_filtros").click(function () {

 
            let tener_customers = $(".tener_customers").val() || "";
            let tener_productos = $(".tener_productos").val() || "";
            let tener_staff = $(".tener_staff").val() || "";

            let tener_fecha_desde = $(".tener_fecha_desde").val() || "";
            let tener_fecha_hasta = $(".tener_fecha_hasta").val() || "";
          
            if(isEmpty(tener_fecha_desde) == true)
            {
                toastr.error("!From date is required¡");
                return;
            }

            if(isEmpty(tener_fecha_hasta) == true)
            {
                toastr.error("!Date by is required¡");
                return;
            }

            //let tener_customers = $(".tener_customers").val() || "";
            //let tener_productos = $(".tener_productos").val() || "";
            //let tener_staff = $(".tener_staff").val() || "";

            let enviar_informacion = {
               fecha_desde: tener_fecha_desde,
               fecha_hasta: tener_fecha_hasta,

               tener_customers: tener_customers,
               tener_productos: tener_productos,
               tener_staff: tener_staff,
                
               role_id: tener_role_id,
            };

            console.log(enviar_informacion);
            console.log("aqui abajo ahi un return");
            //return;

            console.log(URL_BASE);

            

            $("#consultar_filtros").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "invoices/tener-listado-productos-invoices",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  $("#consultar_filtros").prop("disabled", false);
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
                  //$("#myModal").modal("hide");
                  $(".tbody_envios").html("");

                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        
                        let arr = info.data;
                        if (arr == "") {
                           $(".tbody_envios").html(
                            
                              '<tr><th colspan="14" class="centrar pt-4"> No information</th></tr>',
                           );
                        } else {
                           $(".tbody_envios").html(arr);
                           console.log("info");
                           //console.log(info);

                         }

                         
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);
               },
            });
         });

         $("#consultar_filtros_excel").click(function () {

 
            let tener_customers = $(".tener_customers").val() || "";
            let tener_productos = $(".tener_productos").val() || "";
            let tener_staff = $(".tener_staff").val() || "";

            let tener_fecha_desde = $(".tener_fecha_desde").val() || "";
            let tener_fecha_hasta = $(".tener_fecha_hasta").val() || "";
          
            if(isEmpty(tener_fecha_desde) == true)
            {
                toastr.error("!From date is required¡");
                return;
            }

            if(isEmpty(tener_fecha_hasta) == true)
            {
                toastr.error("!Date by is required¡");
                return;
            }

            //let tener_customers = $(".tener_customers").val() || "";
            //let tener_productos = $(".tener_productos").val() || "";
            //let tener_staff = $(".tener_staff").val() || "";

            let enviar_informacion = {
               fecha_desde: tener_fecha_desde,
               fecha_hasta: tener_fecha_hasta,

               tener_customers: tener_customers,
               tener_productos: tener_productos,
               tener_staff: tener_staff,
                
               role_id: tener_role_id,
            };

            console.log(enviar_informacion);
            console.log("aqui abajo ahi un return");
            //return;

 
            

            $("#consultar_filtros_excel").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "invoices/tener-listado-productos-invoices-excel",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               xhrFields: {
                  responseType: 'blob' // Configura la respuesta para manejar archivos binarios
               },
               success: function (response) {
                  $("#consultar_filtros_excel").prop("disabled", false);

                  // Crear una URL para el archivo Blob
                  const url = window.URL.createObjectURL(response);

                  // Crear un elemento <a> para simular la descarga
                  const a = document.createElement('a');
                  a.href = url;
                  a.download = 'List_of_products_by_invoices.xlsx'; // Nombre del archivo
                  document.body.appendChild(a);
                  a.click(); // Simula el clic en el enlace
                  a.remove(); // Elimina el enlace del DOM

                  // Liberar la URL del Blob
                  window.URL.revokeObjectURL(url);
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros_excel").prop("disabled", false);
                  console.error("Error en la solicitud:", error);
               }
            });

         });

 
         function cargar_fecha() {
            const today = new Date();

            // Formatear la fecha como YYYY-MM-DD
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
            const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

            const formattedDate = year + "-" + month + "-" + day;
            return formattedDate;
         }
    
         function isEmpty(value) {
            // Verificar si es null o undefined
            if (value == null) return true;

            // Verificar si es una cadena vacía
            if (typeof value === "string" && value.trim() === "") return true;

            // Verificar si es un array vacío
            if (Array.isArray(value) && value.length === 0) return true;

            // Verificar si es un objeto vacío
            if (typeof value === "object" && Object.keys(value).length === 0) return true;

            return false;
         }
     
 
</script>
{/block}