{extends file="$layouts_admin"}
{block name="head"}

 



{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

</style>


<input
     type="text"
     value="{$aplicacion_id_square}"
     disabled
     hidden
     id="aplicacion_id_square"
/>
<input
     type="text"
     value="{$location_id_square}"
     disabled
     hidden
     id="location_id_square"
/>


<div class="row">

    <div class="col-md-12">

        <div class="panel">
            <div class="panel-hdr">
                
                <h2>Bill Payment</h2>

            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <h2 class="text-center"><span></span>Your trial time or subscription period has ended and you must make a payment</h2>
                    <p class="text-center"><span></span>Enter your payment information to renew your subscription:</p>
                    <br>

                    <div class="px-2">
                        <div class="alert alert-danger" id="emsg" style="display: none;">
                            <span id="emsgbody"></span>
                        </div>

                        <div class="alert alert-success" id="emsgSuccess" style="display: none;">
                            <span id="emsgbodySuccess"></span>
                        </div>

                        <form id="rform">

                            <input type="text"  hidden  class="tener_id_pasarela_pago" value="{$sys_pg["id"]}"  disabled  >
                            <input type="text" hidden  class="tener_base_datos" value="{$factura_maestra["nombre_base_datos"]}" disabled    >

                            <div class="row">

                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="selectPaymentMethod" class="col-sm-3"><span class="h6">Payment method</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="selectPaymentMethod" name="selectPaymentMethod" class="form-control  tenerSelectPaymentMethod" >
                                                <option value="0" selected>Select a payment method</option>

                                                {*
                                                    <option value="1">Cash Register</option>
                                                    <option value="2">Bank Deposit</option>
                                                    <option value="3">Bank Transfer</option>
                                                    <option value="4">Cash</option>
                                                *}

                                                <option value="5">Credit Card</option>
                                                 
                                            </select>
                                        </div>
                                    </div>

                                  
                                 <div class="mb-3 row">
                                        <label for="selectCard" class="col-sm-3"><span class="h6">Select a Card</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="selectCard" name="selectCard" class="form-control  tenerSelectCard" disabled>
                                                <option value="-1" selected>Select a card</option>
                                                <option value="0">Card Creation</option>
                                                {foreach $data as $ds}
                                                <option value="{$ds['id']}"> {$ds['tipo_pasarela_pago']} - {$ds['titular_tarjeta']} - {$ds['numero_tarjeta']}</option>
                                                {/foreach}
                                            </select>
                                        </div>
                                    </div>
                                     
                                </div>

                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="descripcion" class="col-sm-3"><span class="h6">Descriptions</span><span class="text-danger"></span></label>
                                        <div class="col-sm-9">                                  
                                             <textarea id="descripcion" name="descripcion" class="form-control tenerDescripcion" rows="3" cols="50"> </textarea>
                                        </div>
                                    </div>

                                </div>

                                {* formulario seleccion o creacion de tarjeta de credito *}
 
                                <div class="col-md-12 col-sm-12">
                                
                                    <div class="mb-3 row">
                                        <label for="tipoPasarelaPago" class="col-sm-3"><span class="h6">Payment method type</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="tipoPasarelaPago" name="tipoPasarelaPago" class="form-control tipoPasarelaPago" disabled>
                                                 
                                                <option value="Stripe">Stripe</option>
                                                <option value="Square">Square</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>


                                <div class="col-md-12 col-sm-12 MostrarSoloSquare"  style="display:none">
                                    <div class="MostrarSoloSquare"  style="display:none">
                                       <div id="card-container" ></div>
                                    </div>
                                </div>

                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="card_name" class="col-sm-3"><span class="h6">Card Name</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="card_name" name="card_name" class="form-control tenercard_name" disabled autofocus>
                                        </div>
                                    </div>
           
                                   <div class="mb-3 row OpcionesStripe">
                                        <label for="card_number" class="col-sm-3"><span class="h6">Card number</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="card_number" name="card_number" class="form-control tenercard_number" disabled>
                                        </div>
                                    </div>

                                    <div class="mb-3 row mostrarCVV"  style="display: none">
                                        <label for="ccv_code" class="col-sm-3"><span class="h6">CCV code</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="ccv_code" name="ccv_code" class="form-control tenerccv_code" disabled autofocus>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="pais_tarjeta_detalle" class="col-sm-3"><span class="h6">Country</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="pais_tarjeta_detalle" name="pais_tarjeta_detalle" class="form-control tener_pais_tarjeta_detalle" disabled >                                        
                                        </div>
                                    </div> 

                                    <div class="mb-3 row">
                                        <label for="ciudad_tarjeta_detalle" class="col-sm-3"><span class="h6">City</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="ciudad_tarjeta_detalle" name="ciudad_tarjeta_detalle" class="form-control tener_ciudad_tarjeta_detalle" disabled>                                        
                                        </div>
                                    </div> 

                                    <div class="mb-3 row">
                                        <label for="codigo_postal_tarjeta_detalle" class="col-sm-3"><span class="h6">Postal Code</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="codigo_postal_tarjeta_detalle" name="codigo_postal_tarjeta_detalle" class="form-control tener_codigo_postal_tarjeta_detalle" disabled>                                        
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="address" class="col-sm-3"><span class="h6">{$_L['Address']} 1</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="address" name="address" class="form-control teneraddress" disabled>                                        
                                        </div>
                                    </div>

 

                                </div>

        
                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row OpcionesStripe">
                                        <label for="mes_expiracion" class="col-sm-3"><span class="h6">Expiration Month</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                            <select id="mes_expiracion" name="mes_expiracion" class="form-control tener_mes_expiracion" disabled>
                                                <option value="0" selected>Select Expiration Month</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="mb-3 row OpcionesStripe">
                                        <label for="ano_expiracion" class="col-sm-3"><span class="h6">Expiration Year</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">                                  
                                           {*<input type="date" id="ano_expiracion" name="ano_expiracion" class="form-control tener_ano_expiracion" disabled>*}

                                            <select id="ano_expiracion" name="ano_expiracion" class="form-control tener_ano_expiracion mostrarAnoStripe" disabled>
                                                <option value="" disabled selected>YYYY</option>
                                            </select>

                                            <input type="text" id="ano_expiracion" name="ano_expiracion" class="form-control tener_ano_expiracion mostrarAnoSquare" disabled style="display: none;" >
 
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="nombre_tarjeta_detalle" class="col-sm-3"><span class="h6">Name</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">   
                                            <input type="text" autocomplete="off"  id="nombre_tarjeta_detalle" name="nombre_tarjeta_detalle" class="form-control tener_nombre_tarjeta_detalle"   disabled>                                        
                                        </div>
                                    </div>     

                                    <div class="mb-3 row">
                                        <label for="correo_tarjeta_detalle" class="col-sm-3"><span class="h6">Email</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="email" autocomplete="off"  id="correo_tarjeta_detalle" name="correo_tarjeta_detalle" class="form-control tener_correo_tarjeta_detalle"  disabled>                                        
                                        </div>
                                    </div>     

                                    <div class="mb-3 row">
                                        <label for="telefono_tarjeta_detalle" class="col-sm-3"><span class="h6">Phone</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="telefono_tarjeta_detalle" name="telefono_tarjeta_detalle" class="form-control tener_telefono_tarjeta_detalle" disabled >                                        
                                        </div>
                                    </div>   

                                    <div class="mb-3 row">
                                        <label for="direccion_tarjeta_detalle" class="col-sm-3"><span class="h6">{$_L['Address']} 2</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" autocomplete="off"  id="direccion_tarjeta_detalle" name="direccion_tarjeta_detalle" class="form-control tener_direccion_tarjeta_detalle"  disabled>                                        
                                        </div>
                                    </div>      

                                </div>


                                <div class="col-md-12 col-sm-12">
                                    <div class="mb-3 row">
                                        <label for="monto" class="col-sm-3"><span class="h6">Amount to pay</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="monto" name="monto" class="form-control tenermonto" value="{number_format($total, 2, '.', ',')}" disabled autofocus>
                                        </div>
                                    </div>
                                </div>
                           
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">


                                        <button class="btn btn-primary mt-3 me-3" type="submit" id="submit">Pay</button>


                                    </div>
                                </div>
                            </div>


                        </form>
                    </div>

                </div>



            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}
<script>

    var fechaActual = new Date();

    // Obtener la fecha de ayer
    var fechaAyer = new Date(fechaActual);
    fechaAyer.setDate(fechaAyer.getDate() - 1);

    // Formatear la fecha de ayer en el formato YYYY-MM-DD
    var fechaAyerFormateada = fechaAyer.toISOString().slice(0,10);

    // Formatear la fecha actual en el formato YYYY-MM-DD
    var fechaFormateada = fechaActual.toISOString().slice(0,10);

    //$('.tener_ano_expiracion').val(fechaFormateada);
    //$('.tener_ano_expiracion').attr('min', fechaAyerFormateada);

    //tener_ano_expiracion
    function generarAnios() {
            const currentYear = new Date().getFullYear();

   
            var selectAnoExpiracion = $('.tener_ano_expiracion');

            let concat = ""
            for (let i = 50; i >= -50; i--) {

                const year = currentYear + i;
                const value = year.toString().slice(-2); // Últimos 2 dígitos del año

                
                //var opcion = $('<option></option>').attr('value', value).text(year);            
                //selectAnoExpiracion.append(opcion);
                concat += "<option value=\"" + value + "\">" + year + "</option>";
            }

            selectAnoExpiracion.append(concat);

    }
 
    generarAnios();

    var selectMesExpiracion = $('.tener_mes_expiracion');

    const monthNames = [
        'January', 'February', 'March', 'April', 'May', 'June',
        'July', 'August', 'September', 'October', 'November', 'December'
    ];

    for (var i = 1; i <= 12; i++) {
        var opcion = $('<option></option>').attr('value', i).text(monthNames[i - 1]);            
        selectMesExpiracion.append(opcion);
    }

    var idSelectCard = -1;
    var idSelectPaymentGateway = 0;
    var idSelectMethodPayment = 0;

    async function initializeCard(payments) {
        const card = await payments.card( );
        await card.attach("#card-container");
        return card;
    }

    async function tokenize(paymentMethod) {
        const tokenResult = await paymentMethod.tokenize();

        return tokenResult;

        console.log(tokenResult);
        console.log("tokenResult");

        if (tokenResult.status == "OK") {
            return tokenResult.token;
        } else {
            throw new Error(
                "Tokenization failed: " + JSON.stringify(tokenResult.errors),
            );
        }
    }

    var card_datos_square = null;

    $(document).ready(function () {

        async function initializeSquare() {
        
            var aplicacion_id_square = $("#aplicacion_id_square").val();
            var location_id_square = $("#location_id_square").val();
            
            try {
                // Initialize Square Payments SDK
                const payments = window.Square.payments(
                    aplicacion_id_square,
                    location_id_square,
                );

                // Initialize card form (assuming initializeCard is defined)
                const card = await initializeCard(payments);
                return card;

            } catch (error) {
                console.error('Error initializing Square:', error);
                alert(error.message);
                return null;
            }
        }

        card_datos_square = null;
        initializeSquare().then(card => {
            card_datos_square = card; // Store card instance for later use
            console.log('Square card initialized:', card_datos_square);
        });

       
        $(".progress").hide();
        $("#emsg").hide();
        $("#emsgSuccess").hide();
        var _url = '{$_url}';
        
        var $cid = $('#cid');
        $cid.select2();

        $country = $("#country");

        $country.select2();
  
        $("#submit").click(async function (e) {
            e.preventDefault();

            idSelectPaymentGateway = $(".tener_id_pasarela_pago").val();

            var tener_mes_expiracion = "";
            var tener_ano_expiracion = "";
            var card_number = "";
            var cnon_tarjetas_square = "";

            var tipoPasarelaPago = $(".tipoPasarelaPago").val();

            if(idSelectMethodPayment == 0)
            {
                toastr.error("!Select a payment method¡");
                return;
            }else{
                if(idSelectMethodPayment == 5 || idSelectMethodPayment == "5")
                {
                    if(idSelectCard <= -1)
                    {
                        toastr.error("Select a card");
                        return;
                    }

                    if(isEmpty(tipoPasarelaPago) == true)
                    {
                        toastr.error("!Payment method type is required¡");
                        return;
                    }

                    if(isEmpty($(".tenercard_name").val()))
                    {
                        toastr.error("!Card name is required¡");
                        return;
                    }

                    if(( idSelectCard == "0" || idSelectCard == 0) && tipoPasarelaPago == "Stripe" )
                    {
                        
                        let number_card = $(".tenercard_number").val();

                        if(isEmpty(number_card)){
                            toastr.error("!The card number is required¡");
                            return;
                        }

                        if(isEmpty($(".tenerccv_code").val()))
                        {
                            toastr.error("!CCV code is required¡");
                            return;
                        }

                        if($('.tener_mes_expiracion').val() == 0 || $('.tener_mes_expiracion').val() == "0")
                        {
                            toastr.error("!Select Expiration Month¡");
                            return;
                        }
        
                        if( isEmpty($('.tener_ano_expiracion').val())  )
                        {
                            toastr.error("!Select a card expiration year¡");
                            return;
                        }

                        let fechaExpiracionAno = (
                            $('.tener_ano_expiracion').val()  || '0'
                        ).padStart(2, '0');

                        let fechaExpiracionMes = (
                        $('.tener_mes_expiracion').val()  || '0'
                        ).padStart(2, '0');

                        const currentYear = (new Date().getFullYear() % 100)
                            .toString()
                            .padStart(2, '0'); // Últimos dos dígitos del año actual con dos dígitos
                            
                        const currentMonth = (new Date().getMonth() + 1)
                            .toString()
                            .padStart(2, '0'); // Mes actual con dos dígitos

                        // Validación del año
                        if (parseInt(fechaExpiracionAno, 10) < parseInt(currentYear, 10)) {
                            toastr.error("La fecha de expiración le año es inválida");
                            return;
                        } else if (
                            parseInt(fechaExpiracionAno, 10) === parseInt(currentYear, 10)
                        ) {
                            // El año es igual al actual, validar el mes
                            if (parseInt(fechaExpiracionMes, 10) < parseInt(currentMonth, 10)) {
                                // El mes es menor, la validación falla
                                toastr.error("La fecha de expiración el mes es inválida");
                                return;
                            }
                        }
 
                        tener_mes_expiracion = $(".tener_mes_expiracion").val();
                        tener_ano_expiracion = $(".tener_ano_expiracion").val();

                        card_number          = $(".tenercard_number").val();

                    }
                    
                    if( ( idSelectCard == "0" || idSelectCard == 0) && tipoPasarelaPago == "Square" )
                    {
                        
                        try {
                            //console.log("card");
                            //console.log(card_datos_square);

                            const token = await tokenize(card_datos_square);

                            if (token.status == "OK") {
                                console.log(token.token);

                                let details = token.details || {};
                                let card = details.card || {};

                                cnon_tarjetas_square = token.token;

                                //exp_month = card.expMonth;
                                //exp_year  = card.expYear;
                                //numero_tarjeta  = card.last4;

                                tener_mes_expiracion = card.expMonth;
                                tener_ano_expiracion = card.expYear;
                                card_number = card.last4;
 

                            } else {

                                if(Array.isArray(token.errors))
                                {

                                    token.errors.forEach((data) => {
                                        let {
                                            field,
                                            message,
                                            type,
                                        } = data;

                                        toastr.error(message);
                                        return;
                                    });

                                    if(token.errors.length != 0)
                                    {
                                        return;
                                    }

                                }

                            }
                        
                            console.log("Payment Token:", token); // Use this token as source_id
                        } catch (error) {
                            console.error(error);
                            toastr.error('Error: ' + error);
                            return;
                        }

                    }


                    /*
                    if( isEmpty($('.tener_nombre_tarjeta_detalle').val())  )
                    {
                        toastr.error("!Name is required¡");
                        return;
                    }

                    if( isEmpty($('.tener_correo_tarjeta_detalle').val())  )
                    {
                        toastr.error("!Email is required¡");
                        return;
                    }

                    if( isEmpty($('.tener_codigo_postal_tarjeta_detalle').val())  )
                    {
                        toastr.error("!Zip code is required¡");
                        return;
                    }

                    if( isEmpty($('.tener_pais_tarjeta_detalle').val())  )
                    {
                        toastr.error("!Country is required");
                        return;
                    }

                    if( isEmpty($('.tener_ciudad_tarjeta_detalle').val())  )
                    {
                        toastr.error("!City is required¡");
                        return;
                    }

                    if( isEmpty($('.tener_telefono_tarjeta_detalle').val())  )
                    {
                        toastr.error("!Phone is required¡");
                        return;
                    }
                    */

 
                    //

                }
            }

            //if(idSelectPaymentGateway <= 0)
            //{
            //    toastr.error("I can't pay, Contact administrator so I can enable a payment gateway in the option; setting > payment gateway");
            //    return;
            //}

            $('#ibox_form').block({ message:block_msg });

            $("#emsg").hide();
            $("#emsgSuccess").hide();

            //console.log(base_url + 'parnerts/add-parnert-post/');
            //console.log($( "#rform" ).serialize());

            var informacionEnviar = {
                card_id_select:idSelectCard,
                payment_gateway: idSelectPaymentGateway,
                payment_method: idSelectMethodPayment,

                //informacion de la tarjeta cuando card_id_select sea igual a 0
                card_name:      $(".tenercard_name").val(),
                ccv_code:       $(".tenerccv_code").val(),
                address:        $(".teneraddress").val(),
                card_number:    card_number,
                state:          $(".tenerestado").val(),
                base_de_datos:  $(".tener_base_datos").val(),
                descripcion:    $(".tenerDescripcion").val(),                
                //cobro_automatico:  $('.tenercobro_automatico').is(':checked'),

                mes_expiracion:  tener_mes_expiracion,
                ano_expiracion:  tener_ano_expiracion,

                //binding detalles
                nombre_tarjeta_detalle:  $(".tener_nombre_tarjeta_detalle").val(),
                correo_tarjeta_detalle:  $(".tener_correo_tarjeta_detalle").val(),
                codigo_postal_tarjeta_detalle:  $(".tener_codigo_postal_tarjeta_detalle").val(),
                pais_tarjeta_detalle:       $(".tener_pais_tarjeta_detalle").val(),
                ciudad_tarjeta_detalle:     $(".tener_ciudad_tarjeta_detalle").val(),
                telefono_tarjeta_detalle:   $(".tener_telefono_tarjeta_detalle").val(),
                direccion_tarjeta_detalle:  $(".tener_direccion_tarjeta_detalle").val(),
                
                cnon_tarjetas_square: cnon_tarjetas_square,
                tipoPasarelaPago: tipoPasarelaPago,
                             
            };
             
            console.log(JSON.stringify(informacionEnviar));
            //alert("un return aqui abajo");
            //return;
           
            $.post(base_url + 'system/payment-invoice-post-app/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
            .done(function (data) {

                var sbutton = $("#submit");
                if ($.isNumeric(data)) {

                    //window.location = base_url + 'parnerts/list_parnert/' + data;
                    window.location = base_url + 'parnerts/list_parnert';
                }
                else {

                    //console.log(data);
                    /* console.log(data);
                    return; */

                     try {
                         const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            $('#ibox_form').unblock();

                            toastr.success(info.data);
                            window.location = info.redirect;

                            //$(".tenercard_name").val("");
                            //$(".tenerccv_code").val("");
                            //$(".teneraddress").val("");
                            //$(".tenercard_number").val("");
                            //$(".tenerSelectCard").val("-1");

                            idSelectCard = -1;
                            idSelectPaymentGateway = 0;
                            idSelectMethodPayment = 0;

                        }else{
                            $('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(info.data);
                            $("#emsg").show("slow");
                        }
                    } catch (error) {
                        $('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
 
                }
            });
        });

   
        $('.tenerSelectCard').change(function() {
            var selectedValue = $(this).val();
 
            $(".MostrarSoloSquare").css("display","none");

                    
            if(selectedValue == 0 || selectedValue == -1)
            {

                $(".mostrarAnoSquare").css("display","none");
                $(".mostrarAnoStripe").css("display","");

                $(".mostrarCVV").css("display","");
                $(".OpcionesStripe").css("display","");

                $(".tenercard_name").val("");
                $(".tenerccv_code").val("");
                $(".teneraddress").val("");
                $(".tenercard_number").val("");
                $(".tener_nombre_tarjeta_detalle").val("");
                $(".tener_correo_tarjeta_detalle").val("");
                $(".tener_mes_expiracion").val(0);
                $(".tener_ano_expiracion").val("");
                $(".tener_nombre_tarjeta_detalle").val("");
                $(".tener_correo_tarjeta_detalle").val("");
                $(".tener_pais_tarjeta_detalle").val("");
                $(".tener_ciudad_tarjeta_detalle").val("");
                $(".tener_telefono_tarjeta_detalle").val("");
                $(".tener_codigo_postal_tarjeta_detalle").val("");
                $(".tener_direccion_tarjeta_detalle").val("");
                $(".tipoPasarelaPago").val("Stripe");

                //$('.tenercobro_automatico').prop('checked', false);

                idSelectCard = selectedValue;
                $(".tenerSelectCard").val(selectedValue);

                if(selectedValue != 0)
                {
                    $('.tenercard_name').attr('disabled', 'disabled');
                    $('.tenerccv_code').attr('disabled', 'disabled');
                    $('.teneraddress').attr('disabled', 'disabled');
                    $('.tenercard_number').attr('disabled', 'disabled');
                    $('.tener_mes_expiracion').attr('disabled', 'disabled');
                    $('.tener_ano_expiracion').attr('disabled', 'disabled');
                    $('.tener_nombre_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_correo_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_pais_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_ciudad_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_telefono_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_codigo_postal_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_direccion_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tipoPasarelaPago').attr('disabled', 'disabled');

 
                    //$('.tenercobro_automatico').attr('disabled', 'disabled');
                }else{
                    $('.tenercard_name').removeAttr('disabled');
                    $('.tenerccv_code').removeAttr('disabled');
                    $('.teneraddress').removeAttr('disabled');
                    $('.tenercard_number').removeAttr('disabled');
                    $('.tener_mes_expiracion').removeAttr('disabled');
                    $('.tener_ano_expiracion').removeAttr('disabled');
                    $('.tener_nombre_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_correo_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_pais_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_ciudad_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_telefono_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_codigo_postal_tarjeta_detalle').removeAttr('disabled');
                    $('.tener_direccion_tarjeta_detalle').removeAttr('disabled');
                    $('.tipoPasarelaPago').removeAttr('disabled');

                    //$('.tenercobro_automatico').removeAttr('disabled');
                }

                return;
            }else{
                $(".mostrarCVV").css("display","none");
            }
 

            $('.tenercard_name').attr('disabled', 'disabled');
            $('.tenerccv_code').attr('disabled', 'disabled');
            $('.teneraddress').attr('disabled', 'disabled');
            $('.tenercard_number').attr('disabled', 'disabled');
            $('.tener_mes_expiracion').attr('disabled', 'disabled');
            $('.tener_ano_expiracion').attr('disabled', 'disabled');
            $('.tener_nombre_tarjeta_detalle').attr('disabled', 'disabled');
            $('.tener_correo_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tener_pais_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tener_ciudad_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tener_telefono_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tener_codigo_postal_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tener_direccion_tarjeta_detalle').attr('disabled', 'disabled');     
            $('.tipoPasarelaPago').attr('disabled', 'disabled');     

             
            //$('.tenercobro_automatico').attr('disabled', 'disabled');

            idSelectCard = selectedValue;

            let base_datos = $(".tener_base_datos").val();

            $.get(base_url + 'system/get_payment_method_by_id/'+selectedValue+"/"+base_datos, function(data) {

                try {

                    var info = JSON.parse(data);
                    //console.log(info);

                    if(info.type == "success")
                    {
                        $(".OpcionesStripe").css("display","");

                        $(".tipoPasarelaPago").val(info.data.tipo_pasarela_pago);
                        $(".tenercard_name").val(info.data.titular_tarjeta);
                        $(".tenerccv_code").val(info.data.codigo_ccv);
                        $(".teneraddress").val(info.data.direccion);


                        let numero_tarjeta = "";

                        if(isEmpty(info.data.numero_tarjeta) == false)
                        {
                            numero_tarjeta = info.data.numero_tarjeta.slice(-4); 
                        }

                        $(".tenercard_number").val(numero_tarjeta);

                        $(".tener_mes_expiracion").val(info.data.exp_month);

                        const year = info.data.exp_year;
                        const month = info.data.exp_month.toString().padStart(2, '0');
                        const day = '01';
                        
                        const momentFecha = moment(year+"-"+month+"-"+day, "YYYY-M-D");
                        const diasEnMes = momentFecha.daysInMonth();

                        const formattedDate = year+"-"+month+"-"+diasEnMes;

                        if(info.data.tipo_pasarela_pago == "Stripe")
                        {
                            $(".mostrarAnoStripe").css("display", "");
                            $(".mostrarAnoSquare").css("display", "none");
                        }else{
                            $(".mostrarAnoStripe").css("display", "none");
                            $(".mostrarAnoSquare").css("display", "");
                        }

                        $(".tener_ano_expiracion").val(year);

                        $(".tener_nombre_tarjeta_detalle").val(info.data.nombre_detalles);
                        $(".tener_correo_tarjeta_detalle").val(info.data.correo_detalles);
                        $(".tener_pais_tarjeta_detalle").val(info.data.pais_detalles);
                        $(".tener_ciudad_tarjeta_detalle").val(info.data.ciudad_detalles);
                        $(".tener_telefono_tarjeta_detalle").val(info.data.telefono_detalles);
                        $(".tener_codigo_postal_tarjeta_detalle").val(info.data.codigo_postal_detalles);
                        $(".tener_direccion_tarjeta_detalle").val(info.data.direccion_detalles);

                         //$('.tener_ano_expiracion');
        
                        //$('.tenercobro_automatico').prop('checked', info.data.cobro_automatico == 1? true:false);

                        //toastr.error(info.data);
                    }else{
                        toastr.error(info.data);
                        $(".tipoPasarelaPago").val("Stripe");
                        $(".tenercard_name").val("");
                        $(".tenerccv_code").val("");
                        $(".teneraddress").val("");
                        $(".tenercard_number").val("");
                        $(".tener_mes_expiracion").val(0);
                        $(".tener_ano_expiracion").val("");
                        $(".tener_nombre_tarjeta_detalle").val("");
                        $(".tener_correo_tarjeta_detalle").val("");
                        $(".tener_pais_tarjeta_detalle").val("");
                        $(".tener_ciudad_tarjeta_detalle").val("");
                        $(".tener_telefono_tarjeta_detalle").val("");
                        $(".tener_codigo_postal_tarjeta_detalle").val("");
                        $(".tener_direccion_tarjeta_detalle").val("");
       
                        //$('.tenercobro_automatico').prop('checked', false);

                        idSelectCard = -1;
                        $(".tenerSelectCard").val(idSelectCard);
                    }
                } catch (error) {
                    $(".tipoPasarelaPago").val("Stripe");
                    $(".tenercard_name").val("");
                    $(".tenerccv_code").val("");
                    $(".teneraddress").val("");
                    $(".tenercard_number").val("");
                    $(".tener_mes_expiracion").val(0);
                    $(".tener_ano_expiracion").val("");
                    $(".tener_nombre_tarjeta_detalle").val("");
                    $(".tener_correo_tarjeta_detalle").val("");
                    $(".tener_pais_tarjeta_detalle").val("");
                    $(".tener_ciudad_tarjeta_detalle").val("");
                    $(".tener_telefono_tarjeta_detalle").val("");
                    $(".tener_codigo_postal_tarjeta_detalle").val("");
                    $(".tener_direccion_tarjeta_detalle").val("");
                    //$('.tenercobro_automatico').prop('checked', false);
  
                    idSelectCard = -1;
                    $(".tenerSelectCard").val(idSelectCard);
                    toastr.error(error);
                }

            });
            
            //console.log('Selected value on change:', selectedValue);
        });

        $('.tenerSelectPaymentMethod').change(function() {
            var selectedValue = $(this).val();
            idSelectMethodPayment = selectedValue;

            //console.log(idSelectMethodPayment);

            $(".mostrarAnoStripe").css("display","");
            $(".mostrarAnoSquare").css("display","none");
            
            $(".MostrarSoloSquare").css("display","none");
            $(".OpcionesStripe").css("display","");
            $(".mostrarCVV").css("display","none");
              

            if(selectedValue != 0)
            {
               // idSelectPaymentGateway = selectedValue;

                if(selectedValue != 5)
                {
                    $('.tipoPasarelaPago').attr('disabled', 'disabled');
                    $('.tenercard_name').attr('disabled', 'disabled');
                    $('.tenerccv_code').attr('disabled', 'disabled');
                    $('.teneraddress').attr('disabled', 'disabled');
                    $('.tenercard_number').attr('disabled', 'disabled');
                    $('.tenerSelectCard').attr('disabled', 'disabled');
                    $('.tener_nombre_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_correo_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_mes_expiracion').attr('disabled', 'disabled');
                    $('.tener_ano_expiracion').attr('disabled', 'disabled');
                    $('.tener_pais_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_ciudad_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_telefono_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_codigo_postal_tarjeta_detalle').attr('disabled', 'disabled');
                    $('.tener_direccion_tarjeta_detalle').attr('disabled', 'disabled');
 
  
                    $(".tipoPasarelaPago").val("Stripe");
                    $(".tener_telefono_tarjeta_detalle").val("");
                    $(".tenercard_name").val("");
                    $(".tenerccv_code").val("");
                    $(".teneraddress").val("");
                    $(".tenercard_number").val("");
                    idSelectCard = -1;
                    $(".tenerSelectCard").val(idSelectCard);
                    $(".tener_nombre_tarjeta_detalle").val("");
                    $(".tener_correo_tarjeta_detalle").val("");

                    $(".tener_mes_expiracion").val(0);
                    $(".tener_ano_expiracion").val("");
                    $(".tener_pais_tarjeta_detalle").val("");
                    $(".tener_ciudad_tarjeta_detalle").val("");
                    $(".tener_codigo_postal_tarjeta_detalle").val("");
                    $(".tener_direccion_tarjeta_detalle").val("");

                }else{
                    $('.tenerSelectCard').removeAttr('disabled');
                }

            } 

            if(selectedValue == 0)
            {
                $('.tipoPasarelaPago').attr('disabled', 'disabled');
                $('.tenercard_name').attr('disabled', 'disabled');
                $('.tenerccv_code').attr('disabled', 'disabled');
                $('.teneraddress').attr('disabled', 'disabled');
                $('.tenercard_number').attr('disabled', 'disabled');
                $('.tenerSelectCard').attr('disabled', 'disabled');
                $('.tener_nombre_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_correo_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_mes_expiracion').attr('disabled', 'disabled');
                $('.tener_ano_expiracion').attr('disabled', 'disabled');
                $('.tener_pais_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_ciudad_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_telefono_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_codigo_postal_tarjeta_detalle').attr('disabled', 'disabled');
                $('.tener_direccion_tarjeta_detalle').attr('disabled', 'disabled');
 
 
                $(".tipoPasarelaPago").val("Stripe");
                $(".tener_telefono_tarjeta_detalle").val("");
                $(".tenercard_name").val("");
                $(".tenerccv_code").val("");
                $(".teneraddress").val("");
                $(".tenercard_number").val("");
                idSelectCard = -1;
                $(".tenerSelectCard").val(idSelectCard);
                $(".tener_nombre_tarjeta_detalle").val("");
                $(".tener_correo_tarjeta_detalle").val("");

                $(".tener_mes_expiracion").val(0);
                $(".tener_ano_expiracion").val("");
                $(".tener_pais_tarjeta_detalle").val("");
                $(".tener_ciudad_tarjeta_detalle").val("");
                $(".tener_codigo_postal_tarjeta_detalle").val("");
                $(".tener_direccion_tarjeta_detalle").val("");

            }


        });

        $('.tipoPasarelaPago').change(function() {
            var selectedValue = $(this).val();

            
       
            if(selectedValue == "Stripe")
            {
                $(".OpcionesStripe").css("display", "");
                $(".MostrarSoloSquare").css("display", "none");
                $(".mostrarCVV").css("display", "");
            }else{
                $(".OpcionesStripe").css("display", "none");
                $(".MostrarSoloSquare").css("display", "");
                $(".mostrarCVV").css("display", "none");
    
            }
 
            //console.log('Selected value on change:', selectedValue);
        });

        function validarSoloNumeros(input) {
            const number = parseInt(input, 10);
            return !isNaN(number) && number.toString() === input;
        }

        function isEmpty(value) {
            // Verificar si es null o undefined
            if (value == null) return true;

            // Verificar si es una cadena vacía
            if (typeof value === "string" && value.trim() === "") return true;

            // Verificar si es un array vacío
            if (Array.isArray(value) && value.length === 0) return true;

            // Verificar si es un objeto vacío
            if (typeof value === "object" && Object.keys(value).length === 0) return true;

            return false;
        }

        $('#descripcion').on('input', function() {
            let texto = $(this).val();
            // Reemplazar comillas simples y dobles con una cadena vacía
            texto = texto.replace(/['"]/g, '');
            $(this).val(texto);
        });



    });

 
function serach_address(address,secundary,option = 1) {

  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    var settings = {
      "url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
      "method": "GET",
      "timeout": 0,
      "headers": {
        "Host": "us-autocomplete-pro.api.smarty.com",
        "Referer": "https://hispanosdeexitollc.com"
    },
};

$('#browsers').html('');
$('#browsers').show();

$.ajax(settings).done(function (response) {

  $.each(response.suggestions, function (k, v) {
    let text=v.street_line+' '+v.secondary+' '+v.card_number+', '+v.state+' '+v.zipcode;
    let line=v.street_line+' '+v.secondary+' ('+v.entries+') '+v.card_number+', '+v.state+' '+v.zipcode;
    let line2=v.street_line+' '+v.secondary;
    let entries=(v.entries > 1) ? '<a href="#" data-data1="'+line+'" data-data2="'+line2+'" class="addresssec"><span class="badge bg-primary rounded-pill">+ '+v.entries+' Address</span></a>' : "" ;
    let option='<li class="list-group-item d-flex justify-content-between align-items-start "><div class="ms-2 me-auto address1" data-data1="'+v.card_number+'" data-data2="'+v.state+'" data-data3="'+v.zipcode+'" data-data4="'+v.street_line+' '+v.secondary+'"><div class="fw-bold">'+text+'</div></div>'+entries+'</li>';
    $('#browsers').append(option);
    x++;
});
});
}
}


$("input[name='address']").on('input', function(e){
  var address = $(this).val();
  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,"",1);    
}
});


$(document).on('click', '.address1', function(e){
    e.preventDefault();
    $('#card_number').val($(this).data('data1'));
    $('#state').val($(this).data('data2'));
    $('#zip').val($(this).data('data3'));
    $('#address').val($(this).data('data4'));
    $('#browsers').hide();

});


$(document).on('click', '.addresssec', function(e){
    e.preventDefault();
    let address=$(this).data('data2');
    $('#address').val(address);
    let secundary=$(this).data('data1');
    secundary = secundary.replace(/,/g, "");
    secundary = secundary.replace(/ /g, "+");
    secundary = secundary.replace(/#/g, "%23");
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,secundary,2);
});

</script>
{/block}