{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
   <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />

   <link
   href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
   rel="stylesheet"
   />


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

    .consultar_filtros
    {
      border-color: #d3cac0;
      border: 1px solid #d3cac0;
      float: right;
    }

</style>
<div class="row">
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2 style="color: #666; font-weight: 600">
               <span></span>Payment report
            </h2>
            <input
               type="text"
               class="tener_url_base"
               value="{$url_base}"
               disabled
               hidden
            />
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div class="row contenedor" style="padding: 10px">
                     <div class="col-12 col-sm-6 pt-3">
                        <label for="fecha_desde"
                           ><span style="color: #666">Date from</span>
                        </label>
                        <input
                           type="date"
                           id="fecha_desde"
                           name="fecha_desde"
                           class="form-control form-control-sm tener_fecha_desde"
                        />
                     </div>
                     <div class="col-12 col-sm-6 pt-3">
                        <label for="fecha_hasta"
                           ><span style="color: #666">Date to date</span>
                        </label>
                        <input
                           type="date"
                           id="fecha_hasta"
                           name="fecha_hasta"
                           class="form-control form-control-sm tener_fecha_hasta"
                        />
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="state"
                           ><span style="color: #666">State</span>
                        </label>
                        <select
                           class="form-control form-control-sm state"
                           name="state"
                           id="state"
                           style="width: 100%"
                           placeholder="Select a option"
                        >
                           <option value="">All</option>

                           {foreach $listado_estado_prestamo as $item}
                           <option value="{$item['id']}">
                              {$item['estado']}
                           </option>
                           {/foreach}
                        </select>
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="etapa_prestamo"
                           ><span style="color: #666">Loan stage</span>
                        </label>
                        <select
                           class="form-control form-control-sm etapa_prestamo"
                           name="etapa_prestamo"
                           id="etapa_prestamo"
                           style="width: 100%"
                           placeholder="Select a option"
                        >
                           <option value="">All</option>
                           {foreach $listado_etapas_prestamo as $item}
                           <option value="{$item['id']}">
                              {$item['etapa']}
                           </option>
                           {/foreach}
                        </select>
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="numero_prestamo"
                           ><span style="color: #666">Loan number</span></label
                        >
                        <input
                           type="text"
                           id="numero_prestamo"
                           name="numero_prestamo"
                           class="form-control form-control-sm numero_prestamo"
                        />
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="nombre_cliente"
                           ><span style="color: #666"
                              >Customer name</span
                           ></label
                        >
                        <input
                           type="text"
                           id="nombre_cliente"
                           name="nombre_cliente"
                           class="form-control form-control-sm nombre_cliente"
                        />
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="DNI"
                           ><span style="color: #666">DNI</span></label
                        >
                        <input
                           type="text"
                           id="DNI"
                           name="DNI"
                           class="form-control form-control-sm DNI"
                        />
                     </div>

                     <div class="col-12 col-sm-6 pt-3">
                        <label for="order"
                           ><span style="color: #666">Order</span>
                        </label>
                        <select
                           class="form-control form-control-sm order"
                           name="order"
                           id="order"
                           style="width: 100%"
                           placeholder="Select a option"
                        >
                           <option value="1">Ascendants</option>
                           <option value="2">Descendant</option>
                        </select>
                     </div>

                     <div class="col-12 col-sm-12 pt-3">

                         

                        {**}

                        <button
                           type="button"
                           class="btn btn-default consultar_filtros"
                           id="consultar_filtros"
                           style="
                              border-color: #d3cac0;
                              border: 1px solid #d3cac0;
                              float: right;
                           "
                        >
                           Filter
                        </button>

                        <button
                           class="btn btn-default loading_consultar_filtros"
                           style="
                              display: none;
                              border-color: #d3cac0;
                              border: 1px solid #d3cac0;
                              float: right;
                           "
                           disabled
                        >
                           <div style="display: flex; align-items: center">
                              <span
                                 class="spinner-border spinner-border-sm"
                                 style="
                                    height: 20px;
                                    width: 20px;
                                    margin-right: 5px;
                                 "
                                 role="status"
                                 aria-hidden="true"
                              ></span>
                              Filter
                           </div>
                        </button>

                        {**}  

                        <button
                           type="button"
                           class="btn btn-success descargar_filtros"
                           id="descargar_filtros"
                           style="
                              
                              float: right;
                              margin-right: 10px;
                           "
                        >
                          <i class="fas fa-file-download"></i> Download filter
                        </button>

                        <button
                           class="btn btn-success loading_descargar_filtros"
                           style="
                              display: none;
                              float: right;
                              margin-right: 10px;
                           "
                           disabled
                        >
                           <div style="display: flex; align-items: center">
                              <span
                                 class="spinner-border spinner-border-sm"
                                 style="
                                    height: 20px;
                                    width: 20px;
                                    margin-right: 5px;
                                 "
                                 role="status"
                                 aria-hidden="true"
                              ></span>
                            Download filter
                           </div>
                        </button>

                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

{**}
<div class="col-md-12">
   <div class="panel">
      <div class="panel-container show" id="ibox_form">
         <div class="panel-content" style="padding: 0px">
            <div class="table-responsive">
               <table
                  class="table table-striped table-hover estilosTabla"
                  id="clx_datatable"
                  style="margin: 0px"
               >
                  <thead>
                     <tr>
                        <th class="centrar">Date</th>
                        <th class="centrar">Customer</th>
                      
                        <th class="centrar">No. loan</th>
                        <th class="centrar">State</th>
                        <th class="centrar">Loan stage</th>
                        <th class="centrar">Requested value</th>
                        <th class="centrar">Product</th>
                        <th class="centrar"></th>
                     </tr>
                  </thead>

                  <tbody class="tbody_envios">
                    
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>
</div>




{**}
<div
   class="modal fade"
   id="ventana_confirmacion"
   tabindex="-1"
   aria-labelledby="exampleModalLabel__ventanaconfirmacion"
   aria-hidden="true"
   data-bs-backdrop="static"
   data-bs-keyboard="false"
>
   <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content" style="background-color: white">
         <div class="modal-header">
            <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
            <button
               type="button"
               class="btn-close"
               id="btn_close_ventana_confirmacion"
            ></button>
         </div>
         <div
            class="modal-body"
            style="background-color: white; border-radius: 10px"
         >
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                     <div class="panel-content">
                        <div class="px-2">
                           <div
                              class="alert alert-danger"
                              id="emsg"
                              style="display: none"
                           >
                              <span id="emsgbody"></span>
                           </div>
                           <input
                              class="tipo_modal_confirmar"
                              hidden
                              disabled
                           />
                           <input class="data_id" hidden disabled />
                           <div class="row">
                              <div class="col-md-12 col-sm-12">
                                 <h4
                                    class="mensaje_modal_confirmar"
                                    style="text-align: center; color: black"
                                 >
                                    Estas seguro de eliminar
                                 </h4>
                                 <p
                                    class="mensaje_espera_moda_confirmacion mt-3"
                                    style="
                                       text-align: center;
                                       color: red;
                                       font-weight: 600;
                                    "
                                 >
                                    Espere mientras termina el proceso
                                 </p>
                              </div>
                           </div>
                           <div class="row mt-2">
                              <div class="col-md-12">
                                 <div style="float: inline-end">
                                    <button
                                       class="btn me-2"
                                       type="button"
                                       id="btn_cerrar_ventana_confirmacion"
                                       style="background: #001b3b"
                                    >
                                       close
                                    </button>
                                    <button
                                       class="btn"
                                       type="button"
                                       id="btn_aplicar_ventana_confirmacion"
                                       style="background: red"
                                    >
                                       Remove
                                    </button>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

{/block}

{block name="script"}


<script>

   const URL_BASE = $(".tener_url_base").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   $(".tbody_envios").html(
      '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
   );


   $('#submit_modal_confirmacion_correo').on('click', function() {
      window.location = url_dashboard;    
   });
 
   $("#btn_aplicar_ventana_confirmacion").off("click")
   .on("click", function () {

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
      $('#btn_close_ventana_confirmacion').prop('disabled', true);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
       
      let opcion_predefinida = $(".tipo_modal_confirmar").val();
      let data_id = $(".data_id").val();

      if(opcion_predefinida == "eliminar_card_documento")
      {
         $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

         $(".card_eliminar_" + data_id).remove();

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         //$("#ventana_confirmacion").modal("hide");

         ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");
      }

      if(opcion_predefinida == "navegar_pantalla_siguiente")
      {
         window.location = URL_BASE + "credit/search-loans";
      }

      if(opcion_predefinida == "navegar_otras_pantallas")
      {
         window.location = URL_BASE + data_id;
      }
 
   });

   $("#btn_cerrar_ventana_confirmacion").off("click")
   .on("click", function () {
      
      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
      $("#ventana_confirmacion").modal("hide");
    
   });

   $("#btn_close_ventana_confirmacion").off("click")
   .on("click", function () {

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
      
      $("#ventana_confirmacion").modal("hide");
    
   });

   $('.btn_cerrar_confirmacion_modal').click(function() {
      $("#modalMensaje").modal("hide");
   });

   let fecha = cargar_fecha();
   let fecha_iniciar = cargar_primer_dia_mes();

   $(".tener_fecha_desde").val(fecha_iniciar);
   $(".tener_fecha_hasta").val(fecha);


   $("#consultar_filtros").click(function () {

      let state = $(".state").val() || "";
      let etapa_prestamo = $(".etapa_prestamo").val() || "";
      let numero_prestamo = $(".numero_prestamo").val() || "";
      let nombre_cliente = $(".nombre_cliente").val() || "";
      let DNI = $(".DNI").val() || "";
      let order = $(".order").val() || "";

      let enviar_informacion = {
         fecha_desde: $(".tener_fecha_desde").val() || "",
         fecha_hasta: $(".tener_fecha_hasta").val() || "",
         state: state,
         etapa_prestamo: etapa_prestamo,
         numero_prestamo: numero_prestamo,
         nombre_cliente: nombre_cliente,
         DNI: DNI,
         descargar: 2, 

         order: order,
      };

      //console.log(JSON.stringify(enviar_informacion));
      //return;
      //$("#consultar_filtros").prop("disabled", true);

      $('input, select, button, textarea').prop('disabled', true);

      $('.loading_consultar_filtros').css('display', '');
      $('.consultar_filtros').css('display', 'none');

      $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-loan-filter",
            data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');

               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {


                     let data = info.data || [];

                     if(data.length == 0)
                     {
                        $(".tbody_envios").html(
                           '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
                        );
                     }else{

                        var newRow = "";

                        data.forEach((element) => {
                           let {
                                  UUID_ENC,
                                  fecha_post,
                                  account,
                                  tipo_identificacion_ig,
                                  numero_identificacion_ig,
                                  numero_prestamo,
                                  estado_prestamo_descripcion,
                                  etapa_prestamo_descripcion,
                                  plan_crediticio,
                                  valor_prestamo,
                              } = element;

                     
                              newRow +=
                                 "<tr>" +
                                 '<td class="centrar">' + fecha_post + "</td>" +
                                 '<td class="centrar">' + account + "</td>" +
                                 //'<td class="centrar">' + tipo_identificacion_ig + "</td>" +
                                 //'<td class="centrar">' + numero_identificacion_ig + "</td>" +
                                 '<td class="centrar">' + numero_prestamo + "</td>" +
                                 '<td class="centrar">' + estado_prestamo_descripcion + "</td>" +
                                 '<td class="centrar">' + etapa_prestamo_descripcion + "</td>" +
                                 '<td class="centrar">' + valor_prestamo + "</td>" +
                                 '<td class="centrar">' + plan_crediticio + "</td>" +
                                 '<td class="centrar">' +
                                 '<a href="' + URL_BASE + 'credit/data-loans/' + UUID_ENC + '">' +
                                 '<i class="fa-solid fa-arrow-right"></i>' +
                                 '</a>' +
                                 "</td>" +
                                 "</tr>";
                        });

                        // Agregar la nueva fila al tbody
                        $(".tbody_envios").html(newRow);

                     }
 
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');
            },
         });

 
      console.log(enviar_informacion);
      return;

      $.ajax({
         type: "POST",
         url: URL_BASE + "social/tener-listado-mensajes-grupales/",
         data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
            $("#consultar_filtros").prop("disabled", false);
            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor
            //$("#myModal").modal("hide");


            $(".tbody_envios").html("");
            try {
               let info = JSON.parse(response);
               if (info.type == "success") {
                  let arr = info.data;

                  if (arr == "") {
                     $(".tbody_envios").html(
                        '<tr><th colspan="9" class="centrar pt-4"> No information</th></tr>',
                     );
                  } else {
                     $(".tbody_envios").html(arr);
                  }

                  /*  if (Array.isArray(arr)) {
                     if (arr.length != 0) {
                        var newRow = "";

                        arr.forEach((element) => {
                           let {
                              id,
                              campaign,
                              crm_groups_id,
                              channel,
                              template,
                              send_date,
                              configuration_whatsapp_other_id,
                              contacts_total,
                              contact_sent,
                              contacts_pending,
                              state_description,
                              state,
                              users_id,
                              user_fullname,
                              user_username,
                              config_identifier,
                           } = element;

                           // Crear una nueva fila de la tabla concatenando cadenas
                           newRow +=
                              "<tr>" +
                              '<td class="centrar">' +
                              send_date +
                              "</td>" +
                              '<td class="centrar">' +
                              channel +
                              "</td>" +
                              '<td class="centrar">' +
                              campaign +
                              "</td>" +
                              '<td class="centrar">' +
                              config_identifier +
                              "</td>" +
                              '<td class="centrar">' +
                              contacts_total +
                              "</td>" +
                              '<td class="centrar">' +
                              contact_sent +
                              "</td>" +
                              '<td class="centrar">' +
                              contacts_pending +
                              "</td>" +
                              '<td class="centrar">' +
                              state_description +
                              "</td>" +
                              "</tr>";
                        });

                        // Agregar la nueva fila al tbody
                        $(".tbody_envios").html(newRow);
                     } else {
                        $(".tbody_envios").html(
                           '<tr><th colspan="8" class="centrar pt-4"> No information</th></tr>',
                        );
                     }
                  }
                */
               } else {
                  alert("Error sending group messages");
               }
            } catch (error) {
               $(".tbody_envios").html("");
               alert("Error:" + error);
            }
         },
         error: function (xhr, status, error) {
            $("#consultar_filtros").prop("disabled", false);
            $(".tbody_envios").html("");
            console.error("Error en la solicitud:", error);
         },
      });
   });

   $("#descargar_filtros").click(function () {

      let state = $(".state").val() || "";
      let etapa_prestamo = $(".etapa_prestamo").val() || "";
      let numero_prestamo = $(".numero_prestamo").val() || "";
      let nombre_cliente = $(".nombre_cliente").val() || "";
      let DNI = $(".DNI").val() || "";
      let order = $(".order").val() || "";

      let enviar_informacion = {
         fecha_desde: $(".tener_fecha_desde").val() || "",
         fecha_hasta: $(".tener_fecha_hasta").val() || "",
         state: state,
         etapa_prestamo: etapa_prestamo,
         numero_prestamo: numero_prestamo,
         nombre_cliente: nombre_cliente,
         DNI: DNI,
         descargar: 1, 

         order: order,
      };

      //console.log(JSON.stringify(enviar_informacion));
      //return;

      $('input, select, button, textarea').prop('disabled', true);

      $('.loading_descargar_filtros').css('display', '');
      $('.descargar_filtros').css('display', 'none');

      console.log(JSON.stringify(enviar_informacion));
      //return;

      $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-loan-filter",
            data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_descargar_filtros').css('display', 'none');
               $('.descargar_filtros').css('display', '');

               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {


                     let data = info.data || [];

                     if(data.length == 0)
                     {
                        $(".tbody_envios").html(
                           '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
                        );
                     }else{

                        var newRow = "";

                        data.forEach((element) => {
                           let {
                                  UUID_ENC,
                                  fecha_post,
                                  account,
                                  tipo_identificacion_ig,
                                  numero_identificacion_ig,
                                  numero_prestamo,
                                  estado_prestamo_descripcion,
                                  etapa_prestamo_descripcion,
                                  plan_crediticio,
                                  valor_prestamo,
                              } = element;

                     
                              newRow +=
                                 "<tr>" +
                                 '<td class="centrar">' + fecha_post + "</td>" +
                                 '<td class="centrar">' + account + "</td>" +
                                 '<td class="centrar">' + tipo_identificacion_ig + "</td>" +
                                 '<td class="centrar">' + numero_identificacion_ig + "</td>" +
                                 '<td class="centrar">' + numero_prestamo + "</td>" +
                                 '<td class="centrar">' + estado_prestamo_descripcion + "</td>" +
                                 '<td class="centrar">' + etapa_prestamo_descripcion + "</td>" +
                                 '<td class="centrar">' + valor_prestamo + "</td>" +
                                 '<td class="centrar">' + plan_crediticio + "</td>" +
                                 '<td class="centrar">' +
                                 '<a href="' + URL_BASE + 'credit/data-loans/' + UUID_ENC + '">' +
                                 '<i class="fa-solid fa-arrow-right"></i>' +
                                 '</a>' +
                                 "</td>" +
                                 "</tr>";
                        });

                        // Agregar la nueva fila al tbody
                        $(".tbody_envios").html(newRow);

                        if( isEmpty(info.base_excel) == false )
                        {
                           const fileName = 'report.xlsx'; // Nombre del archivo
                           downloadExcel(info.base_excel || '', fileName);
                        }

                     }
 
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_descargar_filtros').css('display', 'none');
               $('.descargar_filtros').css('display', '');
            },
         });

 
      console.log(enviar_informacion);
      return;

      $.ajax({
         type: "POST",
         url: URL_BASE + "social/tener-listado-mensajes-grupales/",
         data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
            $("#consultar_filtros").prop("disabled", false);
            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor
            //$("#myModal").modal("hide");


            $(".tbody_envios").html("");
            try {
               let info = JSON.parse(response);
               if (info.type == "success") {
                  let arr = info.data;

                  if (arr == "") {
                     $(".tbody_envios").html(
                        '<tr><th colspan="9" class="centrar pt-4"> No information</th></tr>',
                     );
                  } else {
                     $(".tbody_envios").html(arr);
                  }
 
               } else {
                  alert("Error sending group messages");
               }
            } catch (error) {
               $(".tbody_envios").html("");
               alert("Error:" + error);
            }
         },
         error: function (xhr, status, error) {
            $("#consultar_filtros").prop("disabled", false);
            $(".tbody_envios").html("");
            console.error("Error en la solicitud:", error);
         },
      });
   });

   function downloadExcel(base64String, fileName) {
      // Convertir la cadena Base64 a binario
      const binaryString = atob(base64String); // Decodificar Base64
      const binaryLength = binaryString.length;
      const bytes = new Uint8Array(binaryLength);

      for (let i = 0; i < binaryLength; i++) {
         bytes[i] = binaryString.charCodeAt(i);
      }

      // Crear un Blob con el contenido del archivo Excel
      const blob = new Blob([bytes], {
         type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
      });

      // Crear un enlace temporal para descargar el archivo
      const link = document.createElement('a');
      link.href = window.URL.createObjectURL(blob);
      link.download = fileName;
      link.click();

      // Limpia la URL temporal
      window.URL.revokeObjectURL(link.href);
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function cargar_fecha() {
      const today = new Date();

      // Formatear la fecha como YYYY-MM-DD
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
      const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

      const formattedDate = year + "-" + month + "-" + day;
      return formattedDate;
   }

   function cargar_primer_dia_mes() {
    const today = new Date();

    // Obtener el año y el mes actual
    const year = today.getFullYear();
    const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos (0-11, por eso +1)

    // Establecer el día como 1
    const day = "01";

    // Formatear la fecha como YYYY-MM-DD
    const formattedDate = year + "-" + month + "-" + day;
    return formattedDate;
}

   function select_html_usuario_sistema(arr) {
      if (arr.length == 0) {
         return;
      }

      var html = '<option value="">' + "None" + "</option>";

      arr.forEach((element) => {
         let value = element;

         html +=
            '<option value="' +
            value["id"] +
            '">' +
            value["fullname"] +
            "</option>";
      });

      return html;
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }
     

</script>
{/block}