{extends file="$layouts_admin"}

{block name="content"}


<div class="subheader">
    <h1 class="subheader-title">
        <i class='subheader-icon fal fa-user-alt'></i> Twilio Config <span class='fw-300'></span>
    </h1>
    <div class="subheader-block d-lg-flex align-items-center">
        <a href="#" class="btn btn-primary add_item waves-effect waves-light" id="add_item"><i class="fal fa-plus"></i> New account</a>
    </div>

</div>

<div class="row">


    <div class="col-md-12">
        <div class="panel">
            <div class="panel-container show">
                <div class="panel-content">


                    <div class="row">

                       <div class="col-md-12 col-sm-6 ib_right_panel">
                        <div  id="ib_data_panel">
                            <table class="table table-bordered table-hover display" id="ib_dt">
                                <thead>
                                    <tr class="heading">
                                        <th></th>
                                        <th>{$_L['Name']}</th>
                                        <th>Account SID</th>
                                        <th>Auth Token</th>
                                        <th>Phones</th>
                                        <th>{$_L['Status']}</th>
                                        <th>Create Date</th>
                                        <th>{$_L['Manage']}</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>


                </div>



            </div>
        </div>
    </div>
</div>

</div>

<input value="{$directorio}" hidden disabled id="directorio_" />



{/block}

{block name="script"}
<script>
    $(function() {

        var _url = $("#_url").val();
        var directorio_ = $("#directorio_").val();

        var $ib_data_panel = $("#ib_data_panel");

        $ib_data_panel.block({ message:block_msg });


        var $modal = $('#cloudonex_body');

        $('[data-bs-toggle="tooltip"]').tooltip();

        //var ib_dt = $('#ib_dt').DataTable( {} );

//Table//
        var ib_dt = $("#ib_dt").DataTable({

            responsive: {
                details: {
                  type: 'column'
              }
          },
          "initComplete": function () {
            $ib_data_panel.unblock();
        },
        columnDefs: [ {
            className: 'control',
            orderable: false,
            targets:   0
        } ],
      //order: [ 1, 'asc' ],
        autoWidth: true,
        bProcessing: false,
        bServerSide: false,
        bInfo: false,


        columns: [
            { data: 'id' , render: function(data, type, row){
                return cel(data, row.id);
            }},
            { data: 'name_twilio' },
            { data: 'sid_twilio' },
            { data: 'auth_token' },

            { data: 'phones' , render: function(data, type, row){
                return phones(data);
            }},

            { data: 'id_status' , render: function(data, type, row){
                return status(data);
            }},
            { data: 'create_date' },
            { data: 'id', render: function(data, type, row){
                return actions(data);
            }},
            ],
    });



//Function to consult client data and fill table//
        function dataTable_init() {
            var url = window.location.href;
            var url2=window.location.pathname;
            var url = url.split(url2);
            var urld=url[1].replace("twilio_config", "data_table");


            $.post('/'+directorio_ +"/" +urld)
            .done(function(resp){
             ib_dt = $("#ib_dt").DataTable();
             ib_dt.clear();
             $.each(resp.datos, function (k, v) {
                ib_dt.row.add(v);
            });
             ib_dt.draw();
             ib_dt.columns.adjust().responsive.recalc();
         }).fail( function(jqXHR, textStatus, errorThrown) {


         });
     }
     dataTable_init();


//Empty field for responsive//
     function cel(wpid, wpactive) {
      actions_cell = '';
      return actions_cell;
  }

//Funcion status//
  function status(wpid) {

      var status='<b style="color:green;">Active</b>';
      if (wpid > 1) {
          status='<b style="color:red;">Inactive</b>';
      }
      return status;
  }

//Funcion status//
  function phones(wpid) {

     var phone="";
     $.each(wpid, function (k, v) {

         phone+="<p>"+v.number_twilio+"</p>";

     });
     return phone;
 }

//function for action buttons//
 function actions(wpid) {

  let x="'contacts/delete/"+wpid+"'";
  actions_cell = '<div ><a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 add_phone" data-bs-toggle="tooltip" title="{$_L['View']}" data-placement="top" id="vid'+wpid+'"><i class="fal fas fa-phone"></i> </a> <a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 cview" data-bs-toggle="tooltip" title="{$_L['View']}" data-placement="top" id="vid'+wpid+'"><i class="fal fa-user-alt"></i> </a> <a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 cedit" data-bs-toggle="tooltip" title="{$_L['Edit']}" data-placement="top" id="eid'+wpid+'"><i class="fal fa-pencil"></i> </a> <a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 cdelete"  data-bs-toggle="tooltip" title="{$_L['Delete']}" data-placement="top" id="did'+wpid+'"><i class="fal fa-trash-alt"></i> </a></div>';
  return actions_cell;
}




var $ib_filter = $("#ib_filter");

$('.add_item').on('click', function(e){
    e.preventDefault();
    $.fancybox.open({
        src  :  base_url + 'settings/modal_twilio/new/',
        touch: false,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {
            }
        },
    });

});


$modal.on('click', '.modal_submit', function(e){
    e.preventDefault();
    $.post( _url + "settings/post_twilio/", $("#ib_modal_form").serialize())
    .done(function( data ) {
        if ($.isNumeric(data)) {
            location.reload();
        }else {
            toastr.error(data);
        }
    });
});


$ib_filter.on('click', function(e) {
    e.preventDefault();

    $ib_data_panel.block({ message:block_msg });

    ib_dt.ajax.reload(
        function () {
            $ib_data_panel.unblock();
        }
        );
});


$ib_data_panel.on('click', '.cdelete', function(e){
    e.preventDefault();
    var lid = this.id;
    app.confirm(_L['are_you_sure'], function(result) {
        if(result){

            $.get(  _url + "settings/delete_twilio/"+lid, function( data ) {
                $ib_data_panel.block({ message:block_msg });

                location.reload();

            });


        }
    });

});

$ib_data_panel.on('click', '.cedit', function(e){
    e.preventDefault();
    var lid = this.id;
    $.fancybox.open({
        src  :  base_url + 'settings/modal_twilio/edit/'+lid,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {

            }
        },
    });



});

$ib_data_panel.on('click', '.cview', function(e){

    e.preventDefault();
    var lid = this.id;

    $.fancybox.open({
        src  :  base_url + 'settings/modal_twilio/view/'+lid,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {

            }
        },
    });


});


//Function to consult client data and fill table//
function dataTable_init_phone(id) {
    var url = window.location.href;
    var url2=window.location.pathname;
    var url = url.split(url2);
    var urld=url[1].replace("twilio_config", "data_table_phone");
    urld=urld.replace("#", "");

    $.post('/app_dev/'+urld+id+'/')
    .done(function(resp){
        $('#datos_phone').empty();
        $.each(resp.datos, function (k, v) {
            $('#datos_phone').append('<div class="col-md-6 col-sm-6 text-center"><b>'+v.number_twilio+'</b></div> <div class="col-md-6 col-sm-6 text-center"><a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 cedittlf" data-bs-toggle="tooltip" title="{$_L['Edit']}" data-placement="top" data-data1="'+v.id+'" data-data2="'+v.number_twilio+'"><i class="fal fa-pencil"></i></a> <a href="#" class="btn btn-secondary-light btn-icon waves-effect waves-themed has-tooltip me-2 cdeletephone"  data-bs-toggle="tooltip" title="{$_L['Delete']}" data-placement="top" data-data1="'+v.id+'" data-data2="'+v.id_twilio+'"><i class="fal fa-trash-alt"></i> </a></div>');
        });
    }).fail( function(jqXHR, textStatus, errorThrown) {


    });
}



$ib_data_panel.on('click', '.add_phone', function(e){
    e.preventDefault();
    var lid = this.id;
    $.fancybox.open({
        src  :  base_url + 'settings/modal_twilio/add_phone/'+lid,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {
                dataTable_init_phone(lid);

            }
        },
    });
});


$modal.on('click', '.modal_submit_phone', function(e){
    e.preventDefault();
    $.post( _url + "settings/post_twilio_tlf/", $("#ib_modal_form_phone").serialize())
    .done(function( data ) {
        if ($.isNumeric(data)) {
            var id= $('#lid').val();
            dataTable_init_phone(id);
            $('#phone').val('');
            $('#act').val('add_phone');
            $('#modal_cancel_phone').hide();
            $('#id_tlf').val('');
            toastr.success("Successfully registered");
            dataTable_init();
        }else {
            toastr.error(data);
        }
    });
});

$modal.on('click', '.cedittlf', function(e){
    e.preventDefault();
    var id = $(this).data('data1');
    var data2 = $(this).data('data2');
    $('#phone').val(data2);
    $('#id_tlf').val(id);
    $('#act').val('edit_phone');
    $('#modal_cancel_phone').show();
});

$modal.on('click', '.modal_cancel_phone', function(e){
    e.preventDefault();
    $('#phone').val('');
    $('#act').val('add_phone');
    $('#modal_cancel_phone').hide();
    $('#id_tlf').val('');
});


$modal.on('click', '.cdeletephone', function(e){

    e.preventDefault();
    var id = $(this).data('data1');
    var lid = $(this).data('data2');

    $.fancybox.close({});
    app.confirm(_L['are_you_sure'], function(result) {
        if(result){
            $.get(  _url + "settings/delete_phone/"+id, function( data ) {
            });
        }
    
    $.fancybox.open({
        src  :  base_url + 'settings/modal_twilio/add_phone/'+lid,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {
                dataTable_init_phone(lid);
                dataTable_init();
            }
        },
    });

    });

});


});
</script>
{/block}
