{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit-referencia-personal {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-referencia-personal-contacto {
      margin-bottom: 4px; 
      background-color: #005d08; 
      color: white; 
      border: 1px solid rgb(211, 202, 192) !important; 
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
      float: inline-end;
      width: 40px;
   }

   .btn-eliminar-referencia-personal {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-referencia-personal:hover i,
   .btn-eliminar-referencia-personal:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
      width: 150px;
   }

   .btn-edit-aval {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-aval {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-eliminar-aval-contacto {
      margin-bottom: 4px; 
      background-color: #005d08; 
      color: white; 
      border: 1px solid rgb(211, 202, 192) !important; 
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
      float: inline-end;
      width: 40px;
   }

   .btn-edit-aval:hover i,
   .btn-eliminar-aval:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

 
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

    <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

    <input
         type="text"
         value="{$id_ifp}"
         disabled
         hidden
         id="id_ifp"
    />


 

 
<div class="row pantalla_cargada" style="display: none;">

   <div class="col-12 col-lg-12 col-sm-12 col-md-12">
      <div class="panel">
            <div class="panel-hdr">
               <h2><span></span>Prospecting Stages   <span class="ms-2 titulo_cabecera_credito"></span></h2>

               {*
                  <div class="panel-toolbar">
                     <div class="btn-group">
                        <button class="btn btn-sm btn-default btn-edicion" data-edicion="1">
                        <i class="fa-solid fa-pencil"></i>
                        Enable editing
                        </button>
                     </div>
                  </div>
               *}

              
                

            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    
                  <div class="wrapper">
                     <ul class="breadcrumbs">

                        <li class="cursor_manito enableMenu" data-id="datos_prestamos" style="display: none;">
                           <a>Loan details</a>
                        </li>

                        <li class="cursor_manito enableMenu" data-id="historial_crediticio" style="display: none;">
                           <a>Credit history</a>
                        </li>

                        <li class="cursor_manito" data-id="general_information" >
                        <a>General information</a>
                        </li>

                        <li class="cursor_manito active"  data-id="referencia" >
                        <a>References</a>
                        </li>

                        <li class="cursor_manito"  data-id="documento_respaldo">
                        <a>Supporting documents</a>
                        </li>

                        <li class="cursor_manito"  data-id="preaprobacion" >
                        <a>Pre-approval</a>
                        </li>

                        <li class="cursor_manito"  data-id="plan_pago" >
                        <a>Payment plan</a>
                        </li>

                        <li class="cursor_manito" data-id="desembolzo" >
                        <a>Disbursement</a>
                        </li>

                        <!--  -->
                     </ul>
                  </div>

                </div>
  
               
            </div>
      </div>     
   </div>

    <div class="col-md-12">
        <div class="panel">
            <div class="panel-hdr">
                <h2>Personal references</h2>
                
                <div class="panel-toolbar">
                    <div class="btn-group">
                        <button class="btn btn-sm btn-default waves-effect waves-themed add_reference">Add reference</button>
                     </div>
                </div>
            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row">

                           <div class="col-12 col-sm-12 pt-4">

                              <div class="table-responsive">
                                  <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable_referencia_personal">
                                      <thead>
                                       <tr>
                                             <th class="centrar">Name</th>
                                             <th class="centrar">Workplace</th>
                                             <th class="centrar">Relationship</th>
                                             <th class="centrar">Phone</th>
                                             <th class="centrar">Email</th>
                                             <th class="centrar">Address</th>
                                             <th class="centrar">Client contacted?</th>
                                             <th class="centrar">Observations</th>
                                             <th class="centrar"></th>
                                       </tr>
                                      
                                      </thead>

                                      <tbody class="tbody_envios">
 
                                      </tbody>

                                  </table>
                              </div>

                           </div>

                        </div>
                       
                    </div>

                  

                </div>
 
       
            </div>
        </div>
    </div>

   {**}
   <div class="col-md-12">

         <div class="panel">
               <div class="panel-hdr">
                  <h2>Guarantee</h2>
                  
                  <div class="panel-toolbar">
                     <div class="btn-group">
                           <button class="btn btn-sm btn-default waves-effect waves-themed add_aval">Add guarantee</button>
                        </div>
                  </div>
               </div>

               <div class="panel-container show" id="ibox_form">

                  <div class="panel-content">

                     <div class="px-2">
                           
                           <div class="row">

                              <div class="col-12 col-sm-12 pt-4">

                                 <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable_aval">
                                       <thead>
                                          <tr>
                                                <th class="centrar">Name</th>
                                                <th class="centrar">Workplace</th>
                                                <th class="centrar">Relationship</th>
                                                <th class="centrar">Phone</th>
                                                <th class="centrar">Email</th>
                                                <th class="centrar">Address</th>
                                                <th class="centrar">Client contacted?</th>
                                                <th class="centrar">Observations</th>
                                                <th class="centrar"></th>
                                          </tr>
                                       
                                       </thead>

                                       <tbody class="tbody_envios_aval">
   
                                       </tbody>

                                    </table>
                                 </div>

                              </div>

                           </div>

                           <div class="row">
                              <div class="col-md-12">
                                 <div class="mb-3" style="display: flex;justify-content: space-between;">
   
                                    <button class="btn btn-default mt-2 waves-effect waves-themed back" type="button" id="submit">Back</button>

                                    <div>

                                       <button
                                          class="btn btn-primary mt-2 waves-effect waves-themed guardar_siguiente"
                                          type="button"
                                          id="submit"
                                       >
                                          Next
                                       </button>

                                       <button
                                          class="btn btn-primary mt-2 waves-effect waves-themed loading_guardar_siguiente"
                                          style="display: none"
                                          disabled=""
                                       >
                                          <div style="display: flex; align-items: center">
                                             <span
                                                class="spinner-border spinner-border-sm"
                                                style="height: 20px; width: 20px; margin-right: 5px"
                                                role="status"
                                                aria-hidden="true"
                                             ></span>
                                             Next
                                          </div>
                                       </button>

                                    </div>


                                 </div>
                              </div>
                           </div>

                        
                     </div>

                     

                  </div>
   
         
               </div>
         </div>
   </div>
   
</div>

 
<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the <span style=" font-weight: 600; ">"reference"</span> screen loads...</strong>
         <br />
      </div>
   </div>

</div>





      <div
         class="modal fade"
         id="modalMensaje"
         data-bs-backdrop="static"
         data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="staticBackdropLabel"
         aria-hidden="true"
      >
         <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
               <div class="modal-header">
                  <h5 class="modal-title modal_titulo_mensaje" id="staticBackdropLabel">
                     Group Message
                  </h5>
                  <button
                     type="button"
                     class="btn-close btn_cerrar_confirmacion_modal"
                  ></button>
               </div>
               <div class="modal-body text-center">
                  <p class="modal_contenido_mensaje">
                     The group advertising campaign has been sent. For more
                  </p>
               </div>
            </div>
         </div>
      </div>

   {**}
   <div class="modal fade" id="addReferencePersonal" tabindex="-1" aria-labelledby="exampleModalLabel_" aria-hidden="true"  data-bs-backdrop="static">
      <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 97%; max-width:97%;">
         <div class="modal-content" style="background-color:white">
            <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel_">Personal Reference</h5>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="background-color:white;border-radius:10px">
            
               <div class="row">
                  <div class="col-md-12">
                     <div class="panel-container show" id="ibox_form">
                              <div class="panel-content">
                                 <div class="px-2">
                                       <div class="alert alert-danger" id="emsg" style="display: none;">
                                          <span id="emsgbody"></span>
                                       </div>

                                       <input type="text" id="id_referencia_personal" name="id_referencia_personal" class="form-control id_referencia_personal" disabled hidden/>
                                    
                                          <div class="row">
                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="nombre_completo" class="col-sm-3"><span class="h6">Full name</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="nombre_completo" name="nombre_completo" class="form-control nombre_completo" autofocus >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="lugar_trabajo" class="col-sm-3"><span class="h6">Workplace</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="lugar_trabajo" name="lugar_trabajo" class="form-control lugar_trabajo" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="relacion" class="col-sm-3"><span class="h6">Relationship</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="relacion" name="relacion" class="form-control relacion" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="telefono" class="col-sm-3"><span class="h6">Phone</span><span class="text-danger">*</span></label>

                                                      <div class="col-12 col-sm-3 mt-1">
                                                         <select class="form-control form-control-sm codigo_telefono_rf" id="codigo_telefono_rf" name="codigo_telefono_rf" id="codigo_telefono_rf"></select>
                                                      </div>

                                                      <div class="col-12 col-sm-6 mt-1">
                                                         <input type="number" id="telefono" name="telefono" class="form-control telefono" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="correo_electronico" class="col-sm-3"><span class="h6">Email</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="correo_electronico" name="correo_electronico" class="form-control correo_electronico" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="direccion" class="col-sm-3"><span class="h6">Address</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <textarea rows="3" id="direccion" name="direccion" class="form-control direccion"></textarea>
                                                      </div>
                                                   </div>
                                             </div>

                                          </div>
                                          
                                          <div class="row">
                                             <div class="col-md-12">
                                                   <div class="mb-3" style="float: inline-end;">
   
                                                         <button class="btn btn-primary mt-3 me-3 cambiar_texto_botones" type="button" id="guardar_referencia_personal" style="float: inline-end;">Add</button>

                                                         <button class="btn btn-primary mt-3 me-3 loading_guardar_referencia_personal" style="display: none;" disabled>
                                                            <div style="display: flex; align-items: center">
                                                               <span
                                                               class="spinner-border spinner-border-sm"
                                                               style="height: 20px; width: 20px; margin-right: 5px"
                                                               role="status"
                                                               aria-hidden="true"
                                                               ></span>
                                                               <span class="cambiar_texto_botones">Add</span>
                                                            </div>
                                                         </button>
                                                   
                                                   </div>
                                             </div>
                                          </div>
                                 
                                 </div>
                              </div>
                           </div>
                  </div>
               </div>
            
            </div>
            
         </div>
      </div>
   </div>

   <div class="modal fade" id="addAval" tabindex="-1" aria-labelledby="exampleModalLabel_" aria-hidden="true"  data-bs-backdrop="static">
      <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 97%; max-width:97%;">
         <div class="modal-content" style="background-color:white">
            <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel_">Guarantee</h5>
               <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" style="background-color:white;border-radius:10px">
            
               <div class="row">
                  <div class="col-md-12">
                     <div class="panel-container show" id="ibox_form">
                              <div class="panel-content">
                                 <div class="px-2">
                                       <div class="alert alert-danger" id="emsg" style="display: none;">
                                          <span id="emsgbody"></span>
                                       </div>

                                       <input type="text" id="id_aval" name="id_aval" class="form-control id_aval" disabled hidden/>
                                    
                                          <div class="row">
                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="nombre_completo_aval" class="col-sm-3"><span class="h6">Full name</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="nombre_completo_aval" name="nombre_completo_aval" class="form-control nombre_completo_aval" autofocus >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="lugar_trabajo_aval" class="col-sm-3"><span class="h6">Workplace</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="lugar_trabajo_aval" name="lugar_trabajo_aval" class="form-control lugar_trabajo_aval" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="relacion_aval" class="col-sm-3"><span class="h6">Relationship</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="relacion_aval" name="relacion_aval" class="form-control relacion_aval" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="telefono_aval" class="col-sm-3"><span class="h6">Phone</span><span class="text-danger">*</span></label>
                                                      
                                                      <div class="col-12 col-sm-3 mt-1">
                                                         <select class="form-control form-control-sm codigo_telefono_aval" id="codigo_telefono_aval" name="codigo_telefono_aval" id="codigo_telefono_rf"></select>
                                                      </div>

                                                      <div class="col-12 col-sm-6 mt-1">
                                                         <input type="number" id="telefono_aval" name="telefono_aval" class="form-control telefono_aval" >
                                                      </div>
 
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="correo_electronico_aval" class="col-sm-3"><span class="h6">Email</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <input type="text" id="correo_electronico_aval" name="correo_electronico_aval" class="form-control correo_electronico_aval" >
                                                      </div>
                                                   </div>
                                             </div>

                                             <div class="col-md-12 col-sm-12">
                                                   <div class="mb-3 row">
                                                      <label for="direccion_aval" class="col-sm-3"><span class="h6">Address</span><span class="text-danger">*</span></label>
                                                      <div class="col-sm-9">
                                                         <textarea rows="3" id="direccion_aval" name="direccion_aval" class="form-control direccion_aval"></textarea>
                                                      </div>
                                                   </div>
                                             </div>

                                          </div>
                                          
                                          <div class="row">
                                             <div class="col-md-12">
                                                   <div class="mb-3" style="float: inline-end;">
                                                      <button class="btn btn-primary mt-3 me-3 cambiar_texto_botones" type="button" id="guardar_aval" style="float: inline-end;">Add</button>

                                                      <button class="btn btn-primary mt-3 me-3 loading_guardar_aval" style="display: none;" disabled>
                                                         <div style="display: flex; align-items: center">
                                                            <span
                                                            class="spinner-border spinner-border-sm"
                                                            style="height: 20px; width: 20px; margin-right: 5px"
                                                            role="status"
                                                            aria-hidden="true"
                                                            ></span>
                                                            <span class="cambiar_texto_botones">Add</span>
                                                         </div>
                                                      </button>
                                                   
                                                   </div>
                                             </div>
                                          </div>
                                 
                                 </div>
                              </div>
                           </div>
                  </div>
               </div>
            
            </div>
            
         </div>
      </div>
   </div>

   <div class="modal fade" id="ventana_confirmacion" tabindex="-1" aria-labelledby="exampleModalLabel__ventanaconfirmacion" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" >
      <div class="modal-dialog modal-dialog-centered"  >
         <div class="modal-content" style="background-color:white">
            <div class="modal-header">
            <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
               <button type="button" class="btn-close "  id="btn_close_ventana_confirmacion" ></button>
            </div>
            <div class="modal-body" style="background-color:white;border-radius:10px">
            
               <div class="row">
                  <div class="col-md-12">
                     <div class="panel-container show" id="ibox_form">
                              <div class="panel-content">
                                 <div class="px-2">
                                       <div class="alert alert-danger" id="emsg" style="display: none;">
                                          <span id="emsgbody"></span>
                                       </div>
                                       <input class="tipo_modal_confirmar" hidden disabled/> 
                                       <input class="data_id" hidden disabled/> 
                                       <div class="row">
                                             <div class="col-md-12 col-sm-12">

                                                   <h4 class="mensaje_modal_confirmar" style="text-align:center; color:black">Estas seguro de eliminar</h4>
                                                   
                                                   <p class="mensaje_espera_moda_confirmacion mt-3" style="text-align:center; color:red; font-weight:600">Espere mientras termina el proceso</p>
                                             </div>
                                       
                                          </div>

                                          <div class="row mt-2">
                                             <div class="col-md-12">
                                                   <div  style="float: inline-end;" >

                                                   
                                                      <button class="btn me-2" type="button" id="btn_cerrar_ventana_confirmacion" style=" background: #001b3b; ">close</button>
                                                      <button class="btn " type="button" id="btn_aplicar_ventana_confirmacion" style=" background: red; ">Remove</button>
                                                
                                                      
                                                   </div>
                                             </div>
                                          </div>
                                 </div>
                              </div>
                           </div>
                  </div>
               </div>
            
            </div>
            
         </div>
      </div>
   </div>

{**}

{**}
<div class="modal fade" id="addRFcontacto" tabindex="-1" aria-labelledby="exampleModalLabel_" aria-hidden="true"  data-bs-backdrop="static">
   <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 97%; max-width:97%;">
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h5 class="modal-title" id="exampleModalLabel_">Did you contact a personal reference?</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
         
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input type="text" id="id_rf_contacto" name="id_rf_contacto" class="form-control id_rf_contacto" disabled hidden/>
                                 
                                       <div class="row">
                                       
                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="seContactoRF" class="col-sm-3"><span class="h6">Contacted</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">

                                                      <select
                                                         id="seContactoRF"
                                                         name="seContactoRF"
                                                         class="form-select seContactoRF"
                                                      >
                                                         <option value="1" >Yes, I contacted you.</option>
                                                         <option value="2" >No, I contacted you.</option>
                                                      </select>

                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="observacionesRF" class="col-sm-3"><span class="h6">Observations</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <textarea rows="3" id="observacionesRF" name="observacionesRF" class="form-control observacionesRF"></textarea>
                                                   </div>
                                                </div>
                                          </div>

                                       </div>
                                       
                                       <div class="row">
                                          <div class="col-md-12">
                                                <div class="mb-3" style="float: inline-end;">

                                                      <button class="btn btn-primary mt-3 me-3 cambiar_texto_botones" type="button" id="guardar_rf_contacto" style="float: inline-end;">Add</button>
                                                      <button class="btn btn-primary mt-3 me-3 loading_guardar_rf_contacto" style="display: none;" disabled>
                                                         <div style="display: flex; align-items: center">
                                                            <span
                                                            class="spinner-border spinner-border-sm"
                                                            style="height: 20px; width: 20px; margin-right: 5px"
                                                            role="status"
                                                            aria-hidden="true"
                                                            ></span>
                                                            <span class="cambiar_texto_botones">Add</span>
                                                         </div>
                                                      </button>
                                                
                                                </div>
                                          </div>
                                       </div>
                              
                              </div>
                           </div>
                        </div>
               </div>
            </div>
         
         </div>
         
      </div>
   </div>
</div>

{**}
<div class="modal fade" id="addAvalcontacto" tabindex="-1" aria-labelledby="exampleModalLabel_" aria-hidden="true"  data-bs-backdrop="static">
   <div class="modal-dialog modal-lg modal-dialog-centered" style="width: 97%; max-width:97%;">
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h5 class="modal-title" id="exampleModalLabel_">Did you contact a Guarantee?</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
         
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input type="text" id="id_aval_contacto" name="id_aval_contacto" class="form-control id_aval_contacto" disabled hidden/>
                                 
                                       <div class="row">
                                       
                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="seContactoAval" class="col-sm-3"><span class="h6">Contacted</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">

                                                      <select
                                                         id="seContactoAval"
                                                         name="seContactoAval"
                                                         class="form-select seContactoAval"
                                                      >
                                                         <option value="1" >Yes, I contacted you.</option>
                                                         <option value="2" >No, I contacted you.</option>
                                                      </select>

                                                   </div>
                                                </div>
                                          </div>

                                          <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                   <label for="observacionesAval" class="col-sm-3"><span class="h6">Observations</span><span class="text-danger">*</span></label>
                                                   <div class="col-sm-9">
                                                      <textarea rows="3" id="observacionesAval" name="observacionesAval" class="form-control observacionesAval"></textarea>
                                                   </div>
                                                </div>
                                          </div>

                                       </div>
                                       
                                       <div class="row">
                                          <div class="col-md-12">
                                                <div class="mb-3" style="float: inline-end;">

                                                      <button class="btn btn-primary mt-3 me-3 cambiar_texto_botones" type="button" id="guardar_aval_contacto" style="float: inline-end;">Add</button>
                                                      <button class="btn btn-primary mt-3 me-3 loading_guardar_aval_contacto" style="display: none;" disabled>
                                                         <div style="display: flex; align-items: center">
                                                            <span
                                                            class="spinner-border spinner-border-sm"
                                                            style="height: 20px; width: 20px; margin-right: 5px"
                                                            role="status"
                                                            aria-hidden="true"
                                                            ></span>
                                                            <span class="cambiar_texto_botones">Add</span>
                                                         </div>
                                                      </button>
                                                
                                                </div>
                                          </div>
                                       </div>
                              
                              </div>
                           </div>
                        </div>
               </div>
            </div>
         
         </div>
         
      </div>
   </div>
</div>

 
{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id_ifp   = $("#id_ifp").val();

    

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   var arreglo_referencia_personal = [
      //{
      //   id_referencia_personal: 1,
      //   nombre_completo: "Cesar",
      //   lugar_trabajo: "Workplace",
      //   relacion: "Relationship",
      //   telefono: "9983232",
      //   correo_electronico: "cesar.pineda@itgrahn.com",
      //   direccion: "direccion"
      //}
   ];

   var arreglo_aval = [
      //{
      //   id_aval: 1,
      //   nombre_completo: "Cesar aval",
      //   lugar_trabajo: "Workplace aval",
      //   relacion: "Relationship aval",
      //   telefono: "9983232 aval",
      //   correo_electronico: "cesar.pinedaaval@itgrahn.com",
      //   direccion: "direccion aval"
      //}
   ];

   var menus_disponibles = {};

   let paisesConCodigos = [
        {
           pais: 'United States',
           codigo: '1',
           flag: 'https://flagcdn.com/w20/us.png',
        },
        { pais: 'Honduras', codigo: '504', flag: 'https://flagcdn.com/w20/hn.png' },
        {
           pais: 'Afghanistan',
           codigo: '93',
           flag: 'https://flagcdn.com/w20/af.png',
        },
        { pais: 'Albania', codigo: '355', flag: 'https://flagcdn.com/w20/al.png' },
        { pais: 'Algeria', codigo: '213', flag: 'https://flagcdn.com/w20/dz.png' },
        { pais: 'Andorra', codigo: '376', flag: 'https://flagcdn.com/w20/ad.png' },
        { pais: 'Angola', codigo: '244', flag: 'https://flagcdn.com/w20/ao.png' },
        {
           pais: 'Antigua and Barbuda',
           codigo: '1-268',
           flag: 'https://flagcdn.com/w20/ag.png',
        },
        { pais: 'Argentina', codigo: '54', flag: 'https://flagcdn.com/w20/ar.png' },
        { pais: 'Armenia', codigo: '374', flag: 'https://flagcdn.com/w20/am.png' },
        { pais: 'Australia', codigo: '61', flag: 'https://flagcdn.com/w20/au.png' },
        { pais: 'Austria', codigo: '43', flag: 'https://flagcdn.com/w20/at.png' },
        {
           pais: 'Azerbaijan',
           codigo: '994',
           flag: 'https://flagcdn.com/w20/az.png',
        },
        {
           pais: 'Bahamas',
           codigo: '1-242',
           flag: 'https://flagcdn.com/w20/bs.png',
        },
        { pais: 'Bahrain', codigo: '973', flag: 'https://flagcdn.com/w20/bh.png' },
        {
           pais: 'Bangladesh',
           codigo: '880',
           flag: 'https://flagcdn.com/w20/bd.png',
        },
        {
           pais: 'Barbados',
           codigo: '1-246',
           flag: 'https://flagcdn.com/w20/bb.png',
        },
        { pais: 'Belarus', codigo: '375', flag: 'https://flagcdn.com/w20/by.png' },
        { pais: 'Belgium', codigo: '32', flag: 'https://flagcdn.com/w20/be.png' },
        { pais: 'Belize', codigo: '501', flag: 'https://flagcdn.com/w20/bz.png' },
        { pais: 'Benin', codigo: '229', flag: 'https://flagcdn.com/w20/bj.png' },
        { pais: 'Bhutan', codigo: '975', flag: 'https://flagcdn.com/w20/bt.png' },
        { pais: 'Bolivia', codigo: '591', flag: 'https://flagcdn.com/w20/bo.png' },
        {
           pais: 'Bosnia and Herzegovina',
           codigo: '387',
           flag: 'https://flagcdn.com/w20/ba.png',
        },
        { pais: 'Botswana', codigo: '267', flag: 'https://flagcdn.com/w20/bw.png' },
        { pais: 'Brazil', codigo: '55', flag: 'https://flagcdn.com/w20/br.png' },
        { pais: 'Brunei', codigo: '673', flag: 'https://flagcdn.com/w20/bn.png' },
        { pais: 'Bulgaria', codigo: '359', flag: 'https://flagcdn.com/w20/bg.png' },
        {
           pais: 'Burkina Faso',
           codigo: '226',
           flag: 'https://flagcdn.com/w20/bf.png',
        },
        { pais: 'Burundi', codigo: '257', flag: 'https://flagcdn.com/w20/bi.png' },
        {
           pais: 'Cabo Verde',
           codigo: '238',
           flag: 'https://flagcdn.com/w20/cv.png',
        },
        { pais: 'Cambodia', codigo: '855', flag: 'https://flagcdn.com/w20/kh.png' },
        { pais: 'Cameroon', codigo: '237', flag: 'https://flagcdn.com/w20/cm.png' },
        { pais: 'Canada', codigo: '1', flag: 'https://flagcdn.com/w20/ca.png' },
        {
           pais: 'Central African Republic',
           codigo: '236',
           flag: 'https://flagcdn.com/w20/cf.png',
        },
        { pais: 'Chad', codigo: '235', flag: 'https://flagcdn.com/w20/td.png' },
        { pais: 'Chile', codigo: '56', flag: 'https://flagcdn.com/w20/cl.png' },
        { pais: 'China', codigo: '86', flag: 'https://flagcdn.com/w20/cn.png' },
        { pais: 'Colombia', codigo: '57', flag: 'https://flagcdn.com/w20/co.png' },
        { pais: 'Comoros', codigo: '269', flag: 'https://flagcdn.com/w20/km.png' },
        {
           pais: 'Congo (Brazzaville)',
           codigo: '242',
           flag: 'https://flagcdn.com/w20/cg.png',
        },
        {
           pais: 'Congo (Kinshasa)',
           codigo: '243',
           flag: 'https://flagcdn.com/w20/cd.png',
        },
        {
           pais: 'Costa Rica',
           codigo: '506',
           flag: 'https://flagcdn.com/w20/cr.png',
        },
        { pais: 'Croatia', codigo: '385', flag: 'https://flagcdn.com/w20/hr.png' },
        { pais: 'Cuba', codigo: '53', flag: 'https://flagcdn.com/w20/cu.png' },
        { pais: 'Cyprus', codigo: '357', flag: 'https://flagcdn.com/w20/cy.png' },
        {
           pais: 'Czech Republic',
           codigo: '420',
           flag: 'https://flagcdn.com/w20/cz.png',
        },
        { pais: 'Denmark', codigo: '45', flag: 'https://flagcdn.com/w20/dk.png' },
        { pais: 'Djibouti', codigo: '253', flag: 'https://flagcdn.com/w20/dj.png' },
        {
           pais: 'Dominica',
           codigo: '1-767',
           flag: 'https://flagcdn.com/w20/dm.png',
        },
        {
           pais: 'Dominican Republic',
           codigo: '1-809',
           flag: 'https://flagcdn.com/w20/do.png',
        },
        { pais: 'Ecuador', codigo: '593', flag: 'https://flagcdn.com/w20/ec.png' },
        { pais: 'Egypt', codigo: '20', flag: 'https://flagcdn.com/w20/eg.png' },
        {
           pais: 'El Salvador',
           codigo: '503',
           flag: 'https://flagcdn.com/w20/sv.png',
        },
        {
           pais: 'Equatorial Guinea',
           codigo: '240',
           flag: 'https://flagcdn.com/w20/gq.png',
        },
        { pais: 'Eritrea', codigo: '291', flag: 'https://flagcdn.com/w20/er.png' },
        { pais: 'Estonia', codigo: '372', flag: 'https://flagcdn.com/w20/ee.png' },
        { pais: 'Eswatini', codigo: '268', flag: 'https://flagcdn.com/w20/sz.png' },
        { pais: 'Ethiopia', codigo: '251', flag: 'https://flagcdn.com/w20/et.png' },
        { pais: 'Fiji', codigo: '679', flag: 'https://flagcdn.com/w20/fj.png' },
        { pais: 'Finland', codigo: '358', flag: 'https://flagcdn.com/w20/fi.png' },
        { pais: 'France', codigo: '33', flag: 'https://flagcdn.com/w20/fr.png' },
        { pais: 'Gabon', codigo: '241', flag: 'https://flagcdn.com/w20/ga.png' },
        { pais: 'Gambia', codigo: '220', flag: 'https://flagcdn.com/w20/gm.png' },
        { pais: 'Georgia', codigo: '995', flag: 'https://flagcdn.com/w20/ge.png' },
        { pais: 'Germany', codigo: '49', flag: 'https://flagcdn.com/w20/de.png' },
        { pais: 'Ghana', codigo: '233', flag: 'https://flagcdn.com/w20/gh.png' },
        { pais: 'Greece', codigo: '30', flag: 'https://flagcdn.com/w20/gr.png' },
        {
           pais: 'Grenada',
           codigo: '1-473',
           flag: 'https://flagcdn.com/w20/gd.png',
        },
        {
           pais: 'Guatemala',
           codigo: '502',
           flag: 'https://flagcdn.com/w20/gt.png',
        },
        { pais: 'Guinea', codigo: '224', flag: 'https://flagcdn.com/w20/gn.png' },
        {
           pais: 'Guinea-Bissau',
           codigo: '245',
           flag: 'https://flagcdn.com/w20/gw.png',
        },
        { pais: 'Guyana', codigo: '592', flag: 'https://flagcdn.com/w20/gy.png' },
        { pais: 'Haiti', codigo: '509', flag: 'https://flagcdn.com/w20/ht.png' },
        { pais: 'Hungary', codigo: '36', flag: 'https://flagcdn.com/w20/hu.png' },
        { pais: 'Iceland', codigo: '354', flag: 'https://flagcdn.com/w20/is.png' },
        { pais: 'India', codigo: '91', flag: 'https://flagcdn.com/w20/in.png' },
        { pais: 'Indonesia', codigo: '62', flag: 'https://flagcdn.com/w20/id.png' },
        { pais: 'Iran', codigo: '98', flag: 'https://flagcdn.com/w20/ir.png' },
        { pais: 'Iraq', codigo: '964', flag: 'https://flagcdn.com/w20/iq.png' },
        { pais: 'Ireland', codigo: '353', flag: 'https://flagcdn.com/w20/ie.png' },
        { pais: 'Israel', codigo: '972', flag: 'https://flagcdn.com/w20/il.png' },
        { pais: 'Italy', codigo: '39', flag: 'https://flagcdn.com/w20/it.png' },
        {
           pais: 'Jamaica',
           codigo: '1-876',
           flag: 'https://flagcdn.com/w20/jm.png',
        },
        { pais: 'Japan', codigo: '81', flag: 'https://flagcdn.com/w20/jp.png' },
        { pais: 'Jordan', codigo: '962', flag: 'https://flagcdn.com/w20/jo.png' },
        { pais: 'Kazakhstan', codigo: '7', flag: 'https://flagcdn.com/w20/kz.png' },
        { pais: 'Kenya', codigo: '254', flag: 'https://flagcdn.com/w20/ke.png' },
        { pais: 'Kiribati', codigo: '686', flag: 'https://flagcdn.com/w20/ki.png' },
        { pais: 'Kuwait', codigo: '965', flag: 'https://flagcdn.com/w20/kw.png' },
        {
           pais: 'Kyrgyzstan',
           codigo: '996',
           flag: 'https://flagcdn.com/w20/kg.png',
        },
        { pais: 'Laos', codigo: '856', flag: 'https://flagcdn.com/w20/la.png' },
        { pais: 'Latvia', codigo: '371', flag: 'https://flagcdn.com/w20/lv.png' },
        { pais: 'Lebanon', codigo: '961', flag: 'https://flagcdn.com/w20/lb.png' },
        { pais: 'Lesotho', codigo: '266', flag: 'https://flagcdn.com/w20/ls.png' },
        { pais: 'Liberia', codigo: '231', flag: 'https://flagcdn.com/w20/lr.png' },
        { pais: 'Libya', codigo: '218', flag: 'https://flagcdn.com/w20/ly.png' },
        {
           pais: 'Liechtenstein',
           codigo: '423',
           flag: 'https://flagcdn.com/w20/li.png',
        },
        {
           pais: 'Lithuania',
           codigo: '370',
           flag: 'https://flagcdn.com/w20/lt.png',
        },
        {
           pais: 'Luxembourg',
           codigo: '352',
           flag: 'https://flagcdn.com/w20/lu.png',
        },
        {
           pais: 'Madagascar',
           codigo: '261',
           flag: 'https://flagcdn.com/w20/mg.png',
        },
        { pais: 'Malawi', codigo: '265', flag: 'https://flagcdn.com/w20/mw.png' },
        { pais: 'Malaysia', codigo: '60', flag: 'https://flagcdn.com/w20/my.png' },
        { pais: 'Maldives', codigo: '960', flag: 'https://flagcdn.com/w20/mv.png' },
        { pais: 'Mali', codigo: '223', flag: 'https://flagcdn.com/w20/ml.png' },
        { pais: 'Malta', codigo: '356', flag: 'https://flagcdn.com/w20/mt.png' },
        {
           pais: 'Marshall Islands',
           codigo: '692',
           flag: 'https://flagcdn.com/w20/mh.png',
        },
        {
           pais: 'Mauritania',
           codigo: '222',
           flag: 'https://flagcdn.com/w20/mr.png',
        },
        {
           pais: 'Mauritius',
           codigo: '230',
           flag: 'https://flagcdn.com/w20/mu.png',
        },
        { pais: 'Mexico', codigo: '52', flag: 'https://flagcdn.com/w20/mx.png' },
        {
           pais: 'Micronesia',
           codigo: '691',
           flag: 'https://flagcdn.com/w20/fm.png',
        },
        { pais: 'Moldova', codigo: '373', flag: 'https://flagcdn.com/w20/md.png' },
        { pais: 'Monaco', codigo: '377', flag: 'https://flagcdn.com/w20/mc.png' },
        { pais: 'Mongolia', codigo: '976', flag: 'https://flagcdn.com/w20/mn.png' },
        {
           pais: 'Montenegro',
           codigo: '382',
           flag: 'https://flagcdn.com/w20/me.png',
        },
        { pais: 'Morocco', codigo: '212', flag: 'https://flagcdn.com/w20/ma.png' },
        {
           pais: 'Mozambique',
           codigo: '258',
           flag: 'https://flagcdn.com/w20/mz.png',
        },
        { pais: 'Myanmar', codigo: '95', flag: 'https://flagcdn.com/w20/mm.png' },
        { pais: 'Namibia', codigo: '264', flag: 'https://flagcdn.com/w20/na.png' },
        { pais: 'Nauru', codigo: '674', flag: 'https://flagcdn.com/w20/nr.png' },
        { pais: 'Nepal', codigo: '977', flag: 'https://flagcdn.com/w20/np.png' },
        {
           pais: 'Netherlands',
           codigo: '31',
           flag: 'https://flagcdn.com/w20/nl.png',
        },
        {
           pais: 'New Zealand',
           codigo: '64',
           flag: 'https://flagcdn.com/w20/nz.png',
        },
        {
           pais: 'Nicaragua',
           codigo: '505',
           flag: 'https://flagcdn.com/w20/ni.png',
        },
        { pais: 'Niger', codigo: '227', flag: 'https://flagcdn.com/w20/ne.png' },
        { pais: 'Nigeria', codigo: '234', flag: 'https://flagcdn.com/w20/ng.png' },
        {
           pais: 'North Korea',
           codigo: '850',
           flag: 'https://flagcdn.com/w20/kp.png',
        },
        {
           pais: 'North Macedonia',
           codigo: '389',
           flag: 'https://flagcdn.com/w20/mk.png',
        },
        { pais: 'Norway', codigo: '47', flag: 'https://flagcdn.com/w20/no.png' },
        { pais: 'Oman', codigo: '968', flag: 'https://flagcdn.com/w20/om.png' },
        { pais: 'Pakistan', codigo: '92', flag: 'https://flagcdn.com/w20/pk.png' },
        { pais: 'Palau', codigo: '680', flag: 'https://flagcdn.com/w20/pw.png' },
        { pais: 'Panama', codigo: '507', flag: 'https://flagcdn.com/w20/pa.png' },
        {
           pais: 'Papua New Guinea',
           codigo: '675',
           flag: 'https://flagcdn.com/w20/pg.png',
        },
        { pais: 'Paraguay', codigo: '595', flag: 'https://flagcdn.com/w20/py.png' },
        { pais: 'Peru', codigo: '51', flag: 'https://flagcdn.com/w20/pe.png' },
        {
           pais: 'Philippines',
           codigo: '63',
           flag: 'https://flagcdn.com/w20/ph.png',
        },
        { pais: 'Poland', codigo: '48', flag: 'https://flagcdn.com/w20/pl.png' },
        { pais: 'Portugal', codigo: '351', flag: 'https://flagcdn.com/w20/pt.png' },
        { pais: 'Qatar', codigo: '974', flag: 'https://flagcdn.com/w20/qa.png' },
        { pais: 'Romania', codigo: '40', flag: 'https://flagcdn.com/w20/ro.png' },
        { pais: 'Russia', codigo: '7', flag: 'https://flagcdn.com/w20/ru.png' },
        { pais: 'Rwanda', codigo: '250', flag: 'https://flagcdn.com/w20/rw.png' },
        {
           pais: 'Saint Kitts and Nevis',
           codigo: '1-869',
           flag: 'https://flagcdn.com/w20/kn.png',
        },
        {
           pais: 'Saint Lucia',
           codigo: '1-758',
           flag: 'https://flagcdn.com/w20/lc.png',
        },
        {
           pais: 'Saint Vincent and the Grenadines',
           codigo: '1-784',
           flag: 'https://flagcdn.com/w20/vc.png',
        },
        { pais: 'Samoa', codigo: '685', flag: 'https://flagcdn.com/w20/ws.png' },
        {
           pais: 'San Marino',
           codigo: '378',
           flag: 'https://flagcdn.com/w20/sm.png',
        },
        {
           pais: 'Saudi Arabia',
           codigo: '966',
           flag: 'https://flagcdn.com/w20/sa.png',
        },
        { pais: 'Senegal', codigo: '221', flag: 'https://flagcdn.com/w20/sn.png' },
        { pais: 'Serbia', codigo: '381', flag: 'https://flagcdn.com/w20/rs.png' },
        {
           pais: 'Seychelles',
           codigo: '248',
           flag: 'https://flagcdn.com/w20/sc.png',
        },
        {
           pais: 'Sierra Leone',
           codigo: '232',
           flag: 'https://flagcdn.com/w20/sl.png',
        },
        { pais: 'Singapore', codigo: '65', flag: 'https://flagcdn.com/w20/sg.png' },
        { pais: 'Slovakia', codigo: '421', flag: 'https://flagcdn.com/w20/sk.png' },
        { pais: 'Slovenia', codigo: '386', flag: 'https://flagcdn.com/w20/si.png' },
        {
           pais: 'Solomon Islands',
           codigo: '677',
           flag: 'https://flagcdn.com/w20/sb.png',
        },
        { pais: 'Somalia', codigo: '252', flag: 'https://flagcdn.com/w20/so.png' },
        {
           pais: 'South Africa',
           codigo: '27',
           flag: 'https://flagcdn.com/w20/za.png',
        },
        {
           pais: 'South Korea',
           codigo: '82',
           flag: 'https://flagcdn.com/w20/kr.png',
        },
        {
           pais: 'South Sudan',
           codigo: '211',
           flag: 'https://flagcdn.com/w20/ss.png',
        },
        { pais: 'Spain', codigo: '34', flag: 'https://flagcdn.com/w20/es.png' },
        { pais: 'Sri Lanka', codigo: '94', flag: 'https://flagcdn.com/w20/lk.png' },
        { pais: 'Sudan', codigo: '249', flag: 'https://flagcdn.com/w20/sd.png' },
        { pais: 'Suriname', codigo: '597', flag: 'https://flagcdn.com/w20/sr.png' },
        { pais: 'Sweden', codigo: '46', flag: 'https://flagcdn.com/w20/se.png' },
        {
           pais: 'Switzerland',
           codigo: '41',
           flag: 'https://flagcdn.com/w20/ch.png',
        },
        { pais: 'Syria', codigo: '963', flag: 'https://flagcdn.com/w20/sy.png' },
        { pais: 'Taiwan', codigo: '886', flag: 'https://flagcdn.com/w20/tw.png' },
        {
           pais: 'Tajikistan',
           codigo: '992',
           flag: 'https://flagcdn.com/w20/tj.png',
        },
        { pais: 'Tanzania', codigo: '255', flag: 'https://flagcdn.com/w20/tz.png' },
        { pais: 'Thailand', codigo: '66', flag: 'https://flagcdn.com/w20/th.png' },
        {
           pais: 'Timor-Leste',
           codigo: '670',
           flag: 'https://flagcdn.com/w20/tl.png',
        },
        { pais: 'Togo', codigo: '228', flag: 'https://flagcdn.com/w20/tg.png' },
        { pais: 'Tonga', codigo: '676', flag: 'https://flagcdn.com/w20/to.png' },
        {
           pais: 'Trinidad and Tobago',
           codigo: '1-868',
           flag: 'https://flagcdn.com/w20/tt.png',
        },
        { pais: 'Tunisia', codigo: '216', flag: 'https://flagcdn.com/w20/tn.png' },
        { pais: 'Turkey', codigo: '90', flag: 'https://flagcdn.com/w20/tr.png' },
        {
           pais: 'Turkmenistan',
           codigo: '993',
           flag: 'https://flagcdn.com/w20/tm.png',
        },
        { pais: 'Tuvalu', codigo: '688', flag: 'https://flagcdn.com/w20/tv.png' },
        { pais: 'Uganda', codigo: '256', flag: 'https://flagcdn.com/w20/ug.png' },
        { pais: 'Ukraine', codigo: '380', flag: 'https://flagcdn.com/w20/ua.png' },
        {
           pais: 'United Arab Emirates',
           codigo: '971',
           flag: 'https://flagcdn.com/w20/ae.png',
        },
        {
           pais: 'United Kingdom',
           codigo: '44',
           flag: 'https://flagcdn.com/w20/gb.png',
        },
        { pais: 'Uruguay', codigo: '598', flag: 'https://flagcdn.com/w20/uy.png' },
        {
           pais: 'Uzbekistan',
           codigo: '998',
           flag: 'https://flagcdn.com/w20/uz.png',
        },
        { pais: 'Vanuatu', codigo: '678', flag: 'https://flagcdn.com/w20/vu.png' },
        {
           pais: 'Vatican City',
           codigo: '379',
           flag: 'https://flagcdn.com/w20/va.png',
        },
        { pais: 'Venezuela', codigo: '58', flag: 'https://flagcdn.com/w20/ve.png' },
        { pais: 'Vietnam', codigo: '84', flag: 'https://flagcdn.com/w20/vn.png' },
        { pais: 'Yemen', codigo: '967', flag: 'https://flagcdn.com/w20/ye.png' },
        { pais: 'Zambia', codigo: '260', flag: 'https://flagcdn.com/w20/zm.png' },
        { pais: 'Zimbabwe', codigo: '263', flag: 'https://flagcdn.com/w20/zw.png' },
   ];

 
   $(document).ready(function () {

      let options = '';

      for (const pais of paisesConCodigos) {
        options += '<option value="' + pais.codigo + '" data-icon="' + pais.flag + '">' + pais.pais + ' (+' + pais.codigo + ')</option>';
      }

        // Formatear la opción para mostrar la bandera y el nombre del país
      function formatOption(option) {
          if (!option.id) {
              return option.text; // Placeholder o texto por defecto
          }
          const $option = $(
              '<span>' +
              '<img src="' + option.element.dataset.icon + '" class="img-flag" style="width: 20px; margin-right: 8px; vertical-align: middle;" />' +
              option.text +
              '</span>'
          );
          return $option;
      }

        // Función para permitir búsqueda por nombre del país
        function matchCustom(params, data) {
           if (!params.term || params.term.trim() === '') {
              return data;
           }
           const term = params.term.toLowerCase();
           if (data.text.toLowerCase().indexOf(term) > -1) {
              return data;
           }
           return null;
        }

        $('#codigo_telefono_rf').html(options);

        $('#codigo_telefono_rf').select2({
         templateResult: formatOption,
         templateSelection: formatOption,
         matcher: matchCustom,
         dropdownParent: $('#codigo_telefono_rf').parent() // Asegura que el dropdown se alinee con el contenedor padre
        }).on('select2:open', function() {
         $('.select2-container--open .select2-dropdown').css('z-index', '1060'); // Ajusta este valor según el z-index del modal
        });

      $('#codigo_telefono_aval').html(options);

      $('#codigo_telefono_aval').select2({
       templateResult: formatOption,
       templateSelection: formatOption,
       matcher: matchCustom,
       dropdownParent: $('#codigo_telefono_aval').parent() // Asegura que el dropdown se alinee con el contenedor padre
      }).on('select2:open', function() {
       $('.select2-container--open .select2-dropdown').css('z-index', '1060'); // Ajusta este valor según el z-index del modal
      });

      cargarPrincipal();
 
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';
 
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });

      $('.cursor_manito').click(function() {

         const atributo_data =  $(this).attr('data-id');

         if(atributo_data == "datos_prestamos")
         {
            window.location = URL_BASE + "credit/data-loans/" + UUID_ENC;
         }

         if(atributo_data == "historial_crediticio")
         {
            window.location = URL_BASE + "credit/credit-history/" + UUID_ENC;
         }
    
         if(atributo_data == "general_information")
         {
            if(menus_disponibles.general_information == 1)
            {
               window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
            
         }

         if(atributo_data == "referencia")
         {
            return;

            if(menus_disponibles.referencia == 1)
            {
               window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "documento_respaldo")
         {
            if(menus_disponibles.documento_respaldo == 1)
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "preaprobacion")
         {
            if(menus_disponibles.preaprobacion == 1)
            {
               window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "plan_pago")
         {
            if(menus_disponibles.plan_pago == 1)
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "desembolzo")
         {
            if(menus_disponibles.desembolzo == 1)
            {
               window.location = URL_BASE + "credit/disbursement-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

 
      });

      $('.add_reference').on('click', function() {

         $(".id_referencia_personal").val("");
         $(".nombre_completo").val("");
         $(".lugar_trabajo").val("");
         $(".relacion").val("");
         $(".telefono").val("");
         $(".correo_electronico").val("");
         $(".direccion").val("");

         $(".cambiar_texto_botones").text("Add");
         $("#addReferencePersonal").modal("show");
      });

 
      $('#guardar_referencia_personal').on('click', function() {

 
         let id_referencia_personal = $(".id_referencia_personal").val();

         console.log("id_referencia_personal");
         console.log(id_referencia_personal); 

         let nombre_completo = $(".nombre_completo").val();

         if(isEmpty(nombre_completo))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.nombre_completo');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Full name" is required.');
            return;
         }

         let lugar_trabajo = $(".lugar_trabajo").val();

         if(isEmpty(lugar_trabajo))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.lugar_trabajo');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Workplace" is required.');
            return;
         }

         let relacion = $(".relacion").val();

         if(isEmpty(relacion))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.relacion');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Relationship" is required.');
            return;
         }

         let codigo_telefono_rf = $(".codigo_telefono_rf").val();

         if(isEmpty(codigo_telefono_rf))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.codigo_telefono_rf');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Phone code" is required.');
            return;
         }

         let telefono = $(".telefono").val();

         if(isEmpty(telefono))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.telefono');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Phone" is required.');
            return;
         }

         let correo_electronico = $(".correo_electronico").val();

         if(isEmpty(correo_electronico))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.correo_electronico');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Email" is required.');
            return;
         }

         let direccion = $(".direccion").val();

         if(isEmpty(direccion))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.direccion');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Personal Reference" the field "Address" is required.');
            return;
         }

         if (isInvalidEmail(correo_electronico)) {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.correo_electronico');
               if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            };
            toastr.error('In "Personal Reference" the field "Email" is not a valid email address.');
            return;
         }

         let validacionCaracteres = validatePhoneFormFields();

         if(validacionCaracteres == true){
            return;
         }

         let informacionFrontend = {
            id_referencia_personal: id_referencia_personal,
            id_ifp: id_ifp,
            nombre_completo: nombre_completo,
            lugar_trabajo: lugar_trabajo,
            relacion: relacion,
            codigo_telefono_rf: codigo_telefono_rf,
            telefono: telefono,
            correo_electronico: correo_electronico,
            direccion: direccion,
            seContacto: 2,
            observaciones: "",
         };

         console.log(JSON.stringify(informacionFrontend));

         $('.nombre_completo, .lugar_trabajo, .relacion, .codigo_telefono_rf, .telefono, .correo_electronico, .direccion, .guardar_referencia_personal').prop('disabled', true);
         $('.loading_guardar_referencia_personal').css('display', '');
         $('#guardar_referencia_personal').css('display', 'none');
         

         if(isEmpty(id_referencia_personal) == true)
         {

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-referencia-prospeccion",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.nombre_completo, .lugar_trabajo, .relacion, .codigo_telefono_rf, .telefono, .correo_electronico, .direccion, .guardar_referencia_personal').prop('disabled', false);
                  $('.loading_guardar_referencia_personal').css('display', 'none');
                  $('#guardar_referencia_personal').css('display', '');
                  
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
      
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {
 
                        informacionFrontend.id_referencia_personal = info.ultimo_id; 
            
                        arreglo_referencia_personal.push(informacionFrontend);

                        $(".tbody_envios").html(tabla_html_referencia_personal(arreglo_referencia_personal));
                        eventosTablaReferenciasPersonales();
 
                        $("#addReferencePersonal").modal("hide");

                        ventanaRegistroExito("Record added", "¡The record was added successfully!");

                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);

                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error.", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error.", error);

                  $('.nombre_completo, .lugar_trabajo, .relacion, .codigo_telefono_rf, .telefono, .correo_electronico, .direccion, .guardar_referencia_personal').prop('disabled', false);
                  $('.loading_guardar_referencia_personal').css('display', 'none');
                  $('#guardar_referencia_personal').css('display', '');

               },
            });
 
         }else{
            //cuando es editar

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-referencia-prospeccion",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.nombre_completo, .lugar_trabajo, .relacion, .codigo_telefono_rf, .telefono, .correo_electronico, .direccion, .guardar_referencia_personal').prop('disabled', false);
                  $('.loading_guardar_referencia_personal').css('display', 'none');
                  $('#guardar_referencia_personal').css('display', '');
                  
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
      
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {

                        let BusquedadInformacion = arreglo_referencia_personal.find(function(item) {
                           return item.id_referencia_personal == id_referencia_personal;
                        });

                        if(isEmpty(BusquedadInformacion) == false)
                        {
            
                           BusquedadInformacion.nombre_completo = nombre_completo; 
                           BusquedadInformacion.lugar_trabajo = lugar_trabajo; 
                           BusquedadInformacion.relacion = relacion; 
                           BusquedadInformacion.codigo_telefono_rf = codigo_telefono_rf; 
                           BusquedadInformacion.telefono = telefono; 
                           BusquedadInformacion.correo_electronico = correo_electronico; 
                           BusquedadInformacion.direccion = direccion; 

                           $(".tbody_envios").html(tabla_html_referencia_personal(arreglo_referencia_personal));
                           eventosTablaReferenciasPersonales();

                           $("#addReferencePersonal").modal("hide");

                           ventanaRegistroExito("Record modified", "¡the record was successfully modified!");

                        }
 
                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);
                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);

                  $('.nombre_completo, .lugar_trabajo, .relacion, .codigo_telefono_rf, .telefono, .correo_electronico, .direccion, .guardar_referencia_personal').prop('disabled', false);
                  $('.loading_guardar_referencia_personal').css('display', 'none');
                  $('#guardar_referencia_personal').css('display', '');

               },
            });

 
         }
 
          

      });

      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
 
            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "eliminar_referencia_personal")
            {
               $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

               quitarReference(data_id);
            }

            if(opcion_predefinida == "eliminar_aval")
            {
               $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

               quitarAval(data_id);
            }

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/"+data_id;
            }
       
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });
      
      $('#btn_copiar_hipervinculo').click(function() {

         const url = $('.url_access').attr('href');

         navigator.clipboard.writeText(url)
            .then(() => {
                  alert('URL copied to clipboard: ' + url);  
            })
            .catch(err => {
                  console.error('Error copying URL: ', err);  
            });
      });
 
      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.back').click(function() {
         window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
      });

      $('.guardar_siguiente').click(function() {


         if(menus_disponibles.preaprobacion == 1){
            // && menus_disponibles.estado_prestamo != 5
            window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            return;
         }

 

         $('input, select, button, textarea').prop('disabled', true);

         $('.loading_guardar_siguiente').css('display', '');
         $('.guardar_siguiente').css('display', 'none');

         let dataFront = {
            id: id_ifp,
            stage: "2",
         };

         console.log("dataFront");
         console.log(JSON.stringify(dataFront));
         //return;
   
         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-change-state-referencia-prospeccion",
            data: JSON.stringify(dataFront), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     //jajaja
                     toastr.success(
                         "Record added",
                         "¡Record added successfully!",
                     );

                     setTimeout(() => {
                       window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
                     }, 1000);

                     //navegarPantallaSiguiente(UUID_ENC); 

                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');

            },
         });
 
 
      });

      //para aval
      $('.add_aval').on('click', function() {

         $(".id_aval").val("");
         $(".nombre_completo_aval").val("");
         $(".lugar_trabajo_aval").val("");
         $(".relacion_aval").val("");
         $(".telefono_aval").val("");
         $(".correo_electronico_aval").val("");
         $(".direccion_aval").val("");
         $(".cambiar_texto_botones").text("Add");

         $("#addAval").modal("show");
      });

      $('#guardar_aval').on('click', function() {

         //$('.nombre_completo_aval, .lugar_trabajo, .relacion, .telefono, .correo_electronico, .direccion, .guardar_aval').prop('disabled', true);
         //$('.loading_guardar_aval').css('display', '');
         //$('#guardar_aval').css('display', 'none');
          
         let id_aval = $(".id_aval").val();

         console.log("id_aval");
         console.log(id_aval); 

         let nombre_completo_aval = $(".nombre_completo_aval").val();

         if(isEmpty(nombre_completo_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.nombre_completo_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Full name" is required.');
            return;
         }

         let lugar_trabajo_aval = $(".lugar_trabajo_aval").val();

         if(isEmpty(lugar_trabajo_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.lugar_trabajo_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Workplace" is required.');
            return;
         }

         let relacion_aval = $(".relacion_aval").val();

         if(isEmpty(relacion_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.relacion_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Relationship" is required.');
            return;
         }

         let codigo_telefono_aval = $(".codigo_telefono_aval").val();

         if(isEmpty(codigo_telefono_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.codigo_telefono_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Phone code" is required.');
            return;
         }

         let telefono_aval = $(".telefono_aval").val();

         if(isEmpty(telefono_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.telefono_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Phone" is required.');
            return;
         }

         let correo_electronico_aval = $(".correo_electronico_aval").val();

         if(isEmpty(correo_electronico_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.correo_electronico_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Email" is required.');
            return;
         }

         let direccion_aval = $(".direccion_aval").val();

         if(isEmpty(direccion_aval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.direccion_aval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Guarantee" the field "Address" is required.');
            return;
         }

         if (isInvalidEmail(correo_electronico_aval)) {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.correo_electronico_aval');
               if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            };
            toastr.error('In "Guarantee" the field "Email" is not a valid email address.');
            return;
         }

         let validacionCaracteres = validatePhoneFormFields_aval();

         if(validacionCaracteres == true){
            return;
         }
 
         let informacionFrontend = {
            id_aval: id_aval,
            id_ifp: id_ifp,
            nombre_completo: nombre_completo_aval,
            lugar_trabajo: lugar_trabajo_aval,
            relacion: relacion_aval,
            codigo_telefono_aval: codigo_telefono_aval,
            telefono: telefono_aval,
            correo_electronico: correo_electronico_aval,
            direccion: direccion_aval
         };

         console.log(JSON.stringify(informacionFrontend));

         $('.nombre_completo_aval, .lugar_trabajo_aval, .relacion_aval, .codigo_telefono_aval, .telefono_aval, .correo_electronico_aval, .direccion_aval, .guardar_aval').prop('disabled', true);
         $('.loading_guardar_aval').css('display', '');
         $('#guardar_aval').css('display', 'none');

         //return;

         if(isEmpty(id_aval) == true)
         {

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-aval-prospeccion",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.nombre_completo_aval, .lugar_trabajo_aval, .relacion_aval, .codigo_telefono_aval, .telefono_aval, .correo_electronico_aval, .direccion_aval, .guardar_aval ').prop('disabled', false);
                  $('.loading_guardar_aval').css('display', 'none');
                  $('#guardar_aval').css('display', '');
                  
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {

                        $("#addAval").modal("hide");
 
                        informacionFrontend.id_aval = info.ultimo_id; 
                        arreglo_aval.push(informacionFrontend);

                        $(".tbody_envios_aval").html(tabla_html_aval(arreglo_aval));
                        eventosTablaAval();

                        ventanaRegistroExito("Record added", "¡The record was added successfully!");

                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);

                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error.", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error.", error);

                  $('.nombre_completo_aval, .lugar_trabajo_aval, .relacion_aval, .codigo_telefono_aval, .telefono_aval, .correo_electronico_aval, .direccion_aval, .guardar_aval  ').prop('disabled', false);
                  $('.loading_guardar_aval').css('display', 'none');
                  $('#guardar_aval').css('display', '');

               },
            });
 
         }else{
            //cuando es editar

            $.ajax({
               type: "POST",
               url: URL_BASE + "credit/post-aval-prospeccion",
               data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {

                  $('.nombre_completo_aval, .lugar_trabajo_aval, .relacion_aval, .codigo_telefono_aval, .telefono_aval, .correo_electronico_aval, .direccion_aval, .guardar_aval ').prop('disabled', false);
                  $('.loading_guardar_aval').css('display', 'none');
                  $('#guardar_aval').css('display', '');
                  
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
      
                  try {
                     let info = JSON.parse(response);

                     if (info.type == "success") {

                        let BusquedadInformacion = arreglo_aval.find(function(item) {
                           return item.id_aval == id_aval;
                        });

                        if(isEmpty(BusquedadInformacion) == false)
                        {

                           $("#addAval").modal("hide");
            
                           BusquedadInformacion.nombre_completo = nombre_completo_aval; 
                           BusquedadInformacion.lugar_trabajo = lugar_trabajo_aval; 
                           BusquedadInformacion.relacion = relacion_aval; 
                           BusquedadInformacion.codigo_telefono_aval = codigo_telefono_aval; 
                           BusquedadInformacion.telefono = telefono_aval; 
                           BusquedadInformacion.correo_electronico = correo_electronico_aval; 
                           BusquedadInformacion.direccion = direccion_aval; 

                           $(".tbody_envios_aval").html(tabla_html_aval(arreglo_aval));
                           eventosTablaAval();

                           ventanaRegistroExito("Record modified", "¡the record was successfully modified!");

                        }
 
                     } else if (info.type == "error") {
                        //Swal.fire({
                        //   icon: "error",
                        //   title: "Oops...",
                        //   text: info.message,
                        //});

                        ventanaError("Opps there was an error", info.message);
                     }
                  } catch (error) {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: error,
                     //});

                     ventanaError("Opps there was an error", error);
                  }
               },
               error: function (xhr, status, error) {
                  console.error("Error en la solicitud:", error);
                  // Manejar errores aquí
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);

                  $('.nombre_completo_aval, .lugar_trabajo_aval, .relacion_aval, .codigo_telefono_aval, .telefono_aval, .correo_electronico_aval, .direccion_aval, .guardar_aval').prop('disabled', false);
                  $('.loading_guardar_aval').css('display', 'none');
                  $('#guardar_aval').css('display', '');

               },
            });

             

         }
 
          

      });

      //observaciones
      $('#guardar_rf_contacto').on('click', function() {

 
         let id_rf_contacto = $(".id_rf_contacto").val();

         console.log("id_rf_contacto");
         console.log(id_rf_contacto); 

         let seContactoRF = $(".seContactoRF").val();

         if(isEmpty(seContactoRF))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.seContactoRF');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Did you contact a personal reference?" the field "Contacted" is required.');
            return;
         }

         let observacionesRF = $(".observacionesRF").val() || "";
 
         if (observacionesRF.length > 255) {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.observacionesRF');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }
            toastr.error('!In "Did you contact a personal reference?", the field "Observations remarks exceeds the 255-character maximum".');
            return;
         } 

         let informacionFrontend = {
            id_rf_contacto: id_rf_contacto,
            seContacto: seContactoRF,
            observaciones: observacionesRF,
         };

         console.log(JSON.stringify(informacionFrontend));

         $('.seContactoRF, .observacionesRF').prop('disabled', true);
         
         $('.loading_guardar_rf_contacto').css('display', '');
         $('#guardar_rf_contacto').css('display', 'none');
         
         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-referencia-prospeccion-isContacted",
            data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('.seContactoRF, .observacionesRF').prop('disabled', false);
         
               $('.loading_guardar_rf_contacto').css('display', 'none');
               $('#guardar_rf_contacto').css('display', '');
               
               //console.log("Respuesta del servidor:", response);
               // Hacer algo con la respuesta del servidor
      
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let BusquedadInformacion = arreglo_referencia_personal.find(function(item) {
                        return item.id_referencia_personal == id_rf_contacto;
                     });


                     if(isEmpty(BusquedadInformacion) == false)
                     {
         
                        BusquedadInformacion.seContacto = seContactoRF; 
                        BusquedadInformacion.observaciones = observacionesRF; 

                        $(".tbody_envios").html(tabla_html_referencia_personal(arreglo_referencia_personal));
                        eventosTablaReferenciasPersonales();

                        $("#addRFcontacto").modal("hide");

                        ventanaRegistroExito("Record saved", "¡Information saved successfully!");

                     }
 
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('.seContactoRF, .observacionesRF').prop('disabled', false);
         
               $('.loading_guardar_rf_contacto').css('display', 'none');
               $('#guardar_rf_contacto').css('display', '');

            },
         });

          
 
          

      });

      $('#guardar_aval_contacto').on('click', function() {

 
         let id_aval_contacto = $(".id_aval_contacto").val();

         console.log("id_aval_contacto");
         console.log(id_aval_contacto); 

         let seContactoAval = $(".seContactoAval").val();

         if(isEmpty(seContactoAval))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.seContactoAval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Did you contact a guarantee?" the field "Contacted" is required.');
            return;
         }

         let observacionesAval = $(".observacionesAval").val() || "";
 
         if (observacionesAval.length > 255) {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.observacionesAval');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }
            toastr.error('!In "Did you contact a guarantee?", the field "Observations remarks exceeds the 255-character maximum".');
            return;
         } 

         let informacionFrontend = {
            id_aval_contacto: id_aval_contacto,
            seContacto: seContactoAval,
            observaciones: observacionesAval,
         };

         console.log(JSON.stringify(informacionFrontend));

         $('.seContactoAval, .observacionesAval').prop('disabled', true);
         
         $('.loading_guardar_aval_contacto').css('display', '');
         $('#guardar_aval_contacto').css('display', 'none');
         
         //return;
         
         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-aval-prospeccion-isContacted",
            data: JSON.stringify(informacionFrontend), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('.seContactoAval, .observacionesAval').prop('disabled', false);
         
               $('.loading_guardar_aval_contacto').css('display', 'none');
               $('#guardar_aval_contacto').css('display', '');
               
               //console.log("Respuesta del servidor:", response);
               // Hacer algo con la respuesta del servidor
      
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {
 
                     let BusquedadInformacion = arreglo_aval.find(function(item) {
                        return item.id_aval == id_aval_contacto;
                     });
 
                     if(isEmpty(BusquedadInformacion) == false)
                     {
 
                        BusquedadInformacion.seContacto    = seContactoAval; 
                        BusquedadInformacion.observaciones = observacionesAval; 

                        $(".tbody_envios_aval").html(tabla_html_aval(arreglo_aval));
                        eventosTablaAval();

                        $("#addAvalcontacto").modal("hide");

                        ventanaRegistroExito("Record saved", "¡Information saved successfully!");
 
                     }
 
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('.seContactoAval, .observacionesAval').prop('disabled', false);
         
               $('.loading_guardar_aval_contacto').css('display', 'none');
               $('#guardar_aval_contacto').css('display', '');

            },
         });

          
 
          

      });


   });

   function contadorPosicion()
   {
      //if(menus_disponibles.referencia == 1 || menus_disponibles.referencia == "1")
      //{
      //   menus_disponibles.documento_respaldo = "1";
      //}

      /*
      menus_disponibles = {
         "general_information": "1",
         "referencia": "1",
         "documento_respaldo": "1",
         "preaprobacion": "2",
         "plan_pago": "2",
         "desembolzo": "2",
         "estado_prestamo": "1"
      };

      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Process the object: change the first "2" to "1" and stop
      for (let prop of propertiesToCheck) {
         if (menus_disponibles[prop] == "2") {
            menus_disponibles[prop] = "1";
            break;  
         }
      }
      */

      
      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Find the first "1" and set the next property (if it's "2") to "1"
      for (let i = 0; i < propertiesToCheck.length - 1; i++) {
         const currentProp = propertiesToCheck[i];
         if (menus_disponibles[currentProp] === "1") {
            const nextProp = propertiesToCheck[i + 1];
            if (menus_disponibles[nextProp] === "2") {
                  menus_disponibles[nextProp] = "1";
                  break; // Stop after updating the next property
            }
         }
      }

      // Log the updated object for verification
      console.log("menus_disponibles");
      console.log(menus_disponibles);
 
   }


   function cargarPrincipal()
   {

      let data = {
         id_ifp: id_ifp,
         show_reference: "yes",
         show_aval: "yes",
      };

      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/get-data-references",
         data: JSON.stringify(data),
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
            
            //console.log("Respuesta del servidor:", response);
            // Hacer algo con la respuesta del servidor
   
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  menus_disponibles           = info.menu_habilitados || {};
                  arreglo_referencia_personal = info.data_reference || [];
 
                  $(".tbody_envios").html(tabla_html_referencia_personal(arreglo_referencia_personal));

                  eventosTablaReferenciasPersonales();

                  arreglo_aval = info.data_aval || [];

                  $(".tbody_envios_aval").html(tabla_html_aval(arreglo_aval));
                  eventosTablaAval();

                  if(menus_disponibles.preaprobacion == 1)
                  {
                     $(".btn-edicion").css("display", "none");
                     $(".btn-eliminar-referencia-personal").css("display", "none");
                     $(".btn-edit-referencia-personal").css("display", "none");

                     $(".btn-edit-aval").css("display", "none");
                     $(".btn-eliminar-aval").css("display", "none");

                     $(".btn-eliminar-aval-contacto").css("display", "none");
                     $(".btn-eliminar-referencia-personal-contacto").css("display", "none");

                     $(".add_reference").css("display", "none");
                     $(".add_aval").css("display", "none");
                     $(".guardar_siguiente").css("display", "");

                     if(menus_disponibles.estado_prestamo != 5)
                     {
                        $(".guardar_siguiente").text("Next");
                        $(".guardar_siguiente").attr("disabled", false);
                     }
                      
                  }

                  if(menus_disponibles.desembolzo == 1 && menus_disponibles.estado_prestamo == 4)
                  {
                     $(".enableMenu").css("display", "");
                  }

                  let data_gip = info.data_gip || {};

                  if(Object.keys(data_gip).length != 0)
                  {
                     if(isEmpty(data_gip.numero_credito) == true)
                     {
                        $(".titulo_cabecera_credito").text(" " + data_gip.account);
                     }else{
                        $(".titulo_cabecera_credito").text(" No. Credit: " + data_gip.numero_credito + " - " + data_gip.account);
                     }

                  }
 
                  



                  contadorPosicion();

 
                  $(".cargando_pantalla").css("display", "none");
                  $(".pantalla_cargada").css("display", "");
 
               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
            // Manejar errores aquí
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

       
   }

   function eventosTablaReferenciasPersonales()
   {

      $('.btn-edit-referencia-personal').off('click');
      $('.btn-eliminar-referencia-personal').off('click');
      $('.btn-eliminar-referencia-personal-contacto').off('click');

      $('.btn-edit-referencia-personal').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         let BusquedadInformacion = arreglo_referencia_personal.find(function(item) {
            return item.id_referencia_personal == dataId;
         });

         if(isEmpty(BusquedadInformacion) == false)
         {
            $(".id_referencia_personal").val(dataId);

            $(".nombre_completo").val(BusquedadInformacion.nombre_completo);
            $(".lugar_trabajo").val(BusquedadInformacion.lugar_trabajo);
            $(".relacion").val(BusquedadInformacion.relacion);
            $(".telefono").val(BusquedadInformacion.telefono);
            $(".codigo_telefono_rf").val(BusquedadInformacion.codigo_telefono_rf).trigger("change");
            $(".correo_electronico").val(BusquedadInformacion.correo_electronico);
            $(".direccion").val(BusquedadInformacion.direccion);

            $(".cambiar_texto_botones").text("Modify");

            $("#addReferencePersonal").modal("show");
         }

      });

      $('.btn-eliminar-referencia-personal').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_referencia_personal");
         $(".data_id").val(dataId);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
            
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");

         //$('#clx_datatable_referencia_personal tbody tr').each(function() {
         //      var rowDataId = $(this).find('.btn-eliminar-referencia-personal').data('id');
         //      if (rowDataId == dataId) {
         //         $(this).remove(); // Elimina la fila que coincide con el data-id
         //      }
         //});
    

      });

      $('.btn-eliminar-referencia-personal-contacto').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
 
         let BusquedadInformacion = arreglo_referencia_personal.find(function(item) {
            return item.id_referencia_personal == dataId;
         });

         if(isEmpty(BusquedadInformacion) == false)
         {
            $(".id_rf_contacto").val(dataId);

            $(".seContactoRF").val(BusquedadInformacion.seContacto);
            $(".observacionesRF").val(BusquedadInformacion.observaciones);
            
            $("#addRFcontacto").modal("show");
         }
   

      });
   }

   function eventosTablaAval()
   {

      $('.btn-edit-aval').off('click');
      $('.btn-eliminar-aval').off('click');
      $('.btn-eliminar-aval-contacto').off('click');

      $('.btn-edit-aval').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         let BusquedadInformacion = arreglo_aval.find(function(item) {
            return item.id_aval == dataId;
         });

         if(isEmpty(BusquedadInformacion) == false)
         {
            $(".id_aval").val(dataId);

            $(".nombre_completo_aval").val(BusquedadInformacion.nombre_completo);
            $(".lugar_trabajo_aval").val(BusquedadInformacion.lugar_trabajo);
            $(".relacion_aval").val(BusquedadInformacion.relacion);
            $(".codigo_telefono_aval").val(BusquedadInformacion.codigo_telefono_aval).trigger("change");
            $(".telefono_aval").val(BusquedadInformacion.telefono);
            $(".correo_electronico_aval").val(BusquedadInformacion.correo_electronico);
            $(".direccion_aval").val(BusquedadInformacion.direccion);

            $(".cambiar_texto_botones").text("Modify");

            $("#addAval").modal("show");
         }

      });

      $('.btn-eliminar-aval').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
        
         
         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_aval");
         $(".data_id").val(dataId);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
            
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");
 
      });

      $('.btn-eliminar-aval-contacto').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
 
 
         let BusquedadInformacion = arreglo_aval.find(function(item) {
            return item.id_aval == dataId;
         });


         if(isEmpty(BusquedadInformacion) == false)
         {
            $(".id_aval_contacto").val(dataId);

            $(".seContactoAval").val(BusquedadInformacion.seContacto);
            $(".observacionesAval").val(BusquedadInformacion.observaciones);
            
            $("#addAvalcontacto").modal("show");
         }
   

      });
 
   }


   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }


   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }

   $("#btn_filtro_buscador_clientes").click(async function () {
            
      console.log("btn_filtro_buscador_clientes");

      let filtro = $(".buscador_asignar_clientes").val() || "";

      if (isEmpty(filtro) == true) {
         Swal.fire("the search is empty!");
         return;
      }

      let filtro_staff = filtro.toLowerCase();

      let informacion = {
         filtro: filtro_staff,
      };

      console.log("informacion");
      console.log(informacion);

      $('#btn_filtro_buscador_clientes').prop('disabled', true);

      $.ajax({
            type: "POST",
            url: URL_BASE + "social/filtra-listado-customers",
            data: JSON.stringify(informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('#btn_filtro_buscador_clientes').prop('disabled', false);
               
               //console.log("Respuesta del servidor:", response);
               // Hacer algo con la respuesta del servidor

   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let data = info.data || [];

                     console.log("data");
                     console.log(data);
                     
                     $(".tbody_asignar_clientes").html(tabla_html_customers(data));
                     
                     add_evento_select_cliente_contactos();

                      
                  } else if (info.type == "error") {
                     Swal.fire({
                        icon: "error",
                        title: "Oops...",
                        text: info.message,
                     });
                  }
               } catch (error) {
                  Swal.fire({
                     icon: "error",
                     title: "Oops...",
                     text: error,
                  });
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: error,
               });

               $('#btn_filtro_buscador_clientes').prop('disabled', false);

            },
         });
   
     
   });

   function tabla_html_customers(arreglo) {
      let html = "";
   
      arreglo.forEach(function (element) {
         let { id, account, phone, email, address } = element;

         html +=
            "<tr>" +
            //
            "<td class='centrar'>" +
            account +
            "</td>" +
            //
            "<td class='centrar'>" +
            phone +
            "</td>" +
            //
            "<td class='centrar'>" +
            email +
            "</td>" +
            //
            "<td class='centrar'>" +
            address +
            "</td>" +
            //
            "<td class='centrar'>" +
            "<button class='btn  btn_add_cliente_contacts' type='button' data-cliente_id='" +
            id +
            "' style='border-color: #d3cac0;border: 1px solid #d3cac0;background-color: white;'>Add</button>" +
            "</td>" +
            "</tr>";
      });
   }

   function tabla_html_referencia_personal(arreglo) {
      let html = "";
      
      arreglo.forEach(function (element) {
         let {
               id_referencia_personal,
               nombre_completo,
               lugar_trabajo,
               relacion,
               codigo_telefono_rf = "",
               telefono,
               correo_electronico,
               direccion,
               seContacto,
               observaciones = "",
         } = element;

         let usuarioContactado = "";

         if(seContacto == 2)
         {
            usuarioContactado = "No";
         }else{
            usuarioContactado = "YES";
         }

         if(isEmpty(observaciones))
         {
            observaciones = "";
         }
         

         html +=
               "<tr>" +
               "<td class='centrar'>" + nombre_completo + "</td>" +
               "<td class='centrar'>" + lugar_trabajo + "</td>" +
               "<td class='centrar'>" + relacion + "</td>" +
               "<td class='centrar'>" + codigo_telefono_rf + telefono + "</td>" +
               "<td class='centrar'>" + correo_electronico + "</td>" +
               "<td class='centrar'>" + direccion + "</td>" +
               "<td class='centrar'>" + usuarioContactado + "</td>" +
               "<td class='centrar'>" + observaciones + "</td>" +
               "<td class='centrar'>" +
               "<div class='row' style=' width: 100%; max-width: 100%; '>" +
                  "<div class='col-12 centrar-botones'>" +

                  "<button class='btn btn-sm btn-edit-referencia-personal waves-effect waves-themed' data-id='" + id_referencia_personal + "'>" +
                  "<i class='fas fa-pencil-square tamano-icono' aria-hidden='true'></i>" +
                  "</button>" +

                  "<button class='btn btn-sm btn-eliminar-referencia-personal waves-effect waves-themed' data-id='" + id_referencia_personal + "'>" +
                  "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
                  "</button>" +

                  "<button class='btn btn-sm btn-eliminar-referencia-personal-contacto waves-effect waves-themed' data-id='" + id_referencia_personal + "'>" +
                  "<i class='fas fa-user-edit tamano-icono' aria-hidden='true'></i>" +
                  "</button>" +
                  //
                  "</div>" +
                  

               "</div>" +
               "</td>" +
               "</tr>";
      });

      return html;
   }

   function tabla_html_aval(arreglo) {
      let html = "";
      
      arreglo.forEach(function (element) {
         let {
               id_aval,
               nombre_completo,
               lugar_trabajo,
               relacion,
               codigo_telefono_aval = "",
               telefono,
               correo_electronico,
               direccion,
               seContacto,
               observaciones = "",
         } = element;

         let usuarioContactado = "";

         if(seContacto == 2)
         {
            usuarioContactado = "No";
         }else{
            usuarioContactado = "YES";
         }

         if(isEmpty(observaciones))
         {
            observaciones = "";
         }

         html +=
               "<tr>" +
               "<td class='centrar'>" + nombre_completo + "</td>" +
               "<td class='centrar'>" + lugar_trabajo + "</td>" +
               "<td class='centrar'>" + relacion + "</td>" +
               "<td class='centrar'>" + codigo_telefono_aval + telefono + "</td>" +
               "<td class='centrar'>" + correo_electronico + "</td>" +
               "<td class='centrar'>" + direccion + "</td>" +
               "<td class='centrar'>" + usuarioContactado + "</td>" +
               "<td class='centrar'>" + observaciones + "</td>" +
               "<td class='centrar'>" +

               "<div class='row' style=' width: 100%; max-width: 100%; ' >" +
                  "<div class='col-12 centrar-botones'>" +
                     "<button class='btn btn-sm btn-edit-aval waves-effect waves-themed' data-id='" + id_aval + "'>" +
                     "<i class='fas fa-pencil-square tamano-icono' aria-hidden='true'></i>" +
                     "</button>" +
                     //

                     "<button class='btn btn-sm btn-eliminar-aval waves-effect waves-themed' data-id='" + id_aval + "'>" +
                     "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
                     "</button>" +
                     // 

                     "<button class='btn btn-sm btn-eliminar-aval-contacto waves-effect waves-themed' data-id='" + id_aval + "'>" +
                     "<i class='fas fa-user-edit tamano-icono' aria-hidden='true'></i>" +
                     "</button>" +
                     //

                  "</div>" +
               "</div>" +

               "</td>" +
               "</tr>";
      });

      return html;
   }

   function add_evento_select_cliente_contactos()
   {
      $(".btn_add_cliente_contacts")
      .off("click")
      .on("click", function () {

         let {

            cliente_id,

         } = $(this).data();

         console.log("cliente_id");
         console.log(cliente_id);  
 
      });
   }

   function validatePhoneFormFields() {
      const fields = [
         { selector: '.nombre_completo', section: 'Personal Reference', name: 'Full name' },
         { selector: '.lugar_trabajo', section: 'Personal Reference', name: 'Workplace' },
         { selector: '.relacion', section: 'Personal Reference', name: 'Relationship' },
         { selector: '.telefono', section: 'Personal Reference', name: 'Phone' },
         { selector: '.correo_electronico', section: 'Personal Reference', name: 'Email' },
         { selector: '.direccion', section: 'Personal Reference', name: 'Address' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function validatePhoneFormFields_aval() {
      const fields = [
         { selector: '.nombre_completo_aval', section: 'Guarantee', name: 'Full name' },
         { selector: '.lugar_trabajo_aval', section: 'Guarantee', name: 'Workplace' },
         { selector: '.relacion_aval', section: 'Guarantee', name: 'Relationship' },
         { selector: '.telefono_aval', section: 'Guarantee', name: 'Phone' },
         { selector: '.correo_electronico_aval', section: 'Guarantee', name: 'Email' },
         { selector: '.direccion_aval', section: 'Guarantee', name: 'Address' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

   function quitarReference(data_id)
   {  

      let dataFront = {
         id: data_id,
      };

      //console.log("dataFront");
      //console.log(JSON.stringify(dataFront));
 
      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/post-delete-referencia-prospeccion",
         data: JSON.stringify(dataFront), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
 
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  let indiceAEliminar = arreglo_referencia_personal.findIndex(
                     (obj) => obj.id_referencia_personal == data_id
                  );

                  if (indiceAEliminar !== -1){
                     arreglo_referencia_personal.splice(indiceAEliminar, 1);

                     $(".tbody_envios").html(tabla_html_referencia_personal(arreglo_referencia_personal));
                     eventosTablaReferenciasPersonales();

                     $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
                     $('#btn_close_ventana_confirmacion').prop('disabled', false);
                     $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
                     
                     //$("#ventana_confirmacion").modal("hide");

                     ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

                  }

               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
          
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

   }

   function quitarAval(data_id)
   {  

      let dataFront = {
         id: data_id,
      };

      //console.log("dataFront");
      //console.log(JSON.stringify(dataFront));
 
      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/post-delete-aval-prospeccion",
         data: JSON.stringify(dataFront), // Convertir datos a formato JSON
         contentType: "application/json", // Tipo de contenido JSON
         success: function (response) {
 
            try {
               let info = JSON.parse(response);

               if (info.type == "success") {

                  let indiceAEliminar = arreglo_aval.findIndex(
                     (obj) => obj.id_aval == data_id
                  );

                  if (indiceAEliminar !== -1){
                     arreglo_aval.splice(indiceAEliminar, 1);

                     $(".tbody_envios_aval").html(tabla_html_aval(arreglo_aval));
                     eventosTablaAval();

                     $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
                     $('#btn_close_ventana_confirmacion').prop('disabled', false);
                     $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
                     
                     //$("#ventana_confirmacion").modal("hide");

                     ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

                  }

               } else if (info.type == "error") {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: info.message,
                  //});

                  ventanaError("Opps there was an error", info.message);
               }
            } catch (error) {
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);
            }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
          
            //Swal.fire({
            //   icon: "error",
            //   title: "Oops...",
            //   text: error,
            //});

            ventanaError("Opps there was an error", error);

         },
      });

   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

    


 
 
</script>
{/literal}


{/block}